/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ymate.module.oauth.connector.IOAuthConnectCallbackHandler;
import net.ymate.module.oauth.connector.IOAuthConnectProcessor;
import net.ymate.module.oauth.connector.IOAuthConnectorModuleCfg;
import net.ymate.module.oauth.connector.impl.DefaultConnectCallbackHandler;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.support.IConfigReader;
import net.ymate.platform.core.support.IPasswordProcessor;
import net.ymate.platform.core.support.impl.MapSafeConfigReader;
import org.apache.commons.lang.StringUtils;

public class DefaultOAuthConnectorModuleCfg
implements IOAuthConnectorModuleCfg {
    private YMP __owner;
    private String __cacheNamePrefix;
    private IConfigReader __moduleCfg;
    private IOAuthConnectCallbackHandler __callbackHandler;
    private boolean __isPasswordEncrypted;
    private IPasswordProcessor __password;
    private Map<String, IOAuthConnectProcessor.ConnectInitCfg> __connectInitCfgs = new ConcurrentHashMap<String, IOAuthConnectProcessor.ConnectInitCfg>();

    public DefaultOAuthConnectorModuleCfg(YMP owner) {
        this.__owner = owner;
        this.__moduleCfg = MapSafeConfigReader.bind((Map)owner.getConfig().getModuleConfigs("module.oauth.connector"));
        this.__cacheNamePrefix = StringUtils.trimToEmpty((String)this.__moduleCfg.getString("cache_name_prefix"));
        this.__callbackHandler = (IOAuthConnectCallbackHandler)this.__moduleCfg.getClassImpl("callback_handler_class", IOAuthConnectCallbackHandler.class);
        if (this.__callbackHandler == null) {
            this.__callbackHandler = new DefaultConnectCallbackHandler();
        }
        this.__isPasswordEncrypted = this.__moduleCfg.getBoolean("password_encrypted");
        if (this.__isPasswordEncrypted) {
            try {
                this.__password = (IPasswordProcessor)this.__moduleCfg.getClassImpl("password_class", IPasswordProcessor.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public String getCacheNamePrefix() {
        return this.__cacheNamePrefix;
    }

    @Override
    public IOAuthConnectProcessor.ConnectInitCfg getConnectInitCfg(String name) throws Exception {
        IOAuthConnectProcessor.ConnectInitCfg _initCfg = this.__connectInitCfgs.get(name);
        if (_initCfg == null) {
            String _clientId = null;
            String _clientSecret = null;
            String _redirectUrl = null;
            HashMap<String, String> _attributes = new HashMap<String, String>();
            Map _cfgMap = this.__moduleCfg.getMap(name + ".");
            for (Map.Entry _entry : _cfgMap.entrySet()) {
                if ("client_id".equalsIgnoreCase((String)_entry.getKey())) {
                    _clientId = (String)_entry.getValue();
                    continue;
                }
                if ("client_secret".equalsIgnoreCase((String)_entry.getValue())) {
                    _clientSecret = (String)_entry.getValue();
                    continue;
                }
                if ("redirect_uri".equalsIgnoreCase((String)_entry.getValue())) {
                    _redirectUrl = (String)_entry.getValue();
                    continue;
                }
                _attributes.put((String)_entry.getKey(), (String)_entry.getValue());
            }
            if (StringUtils.isBlank(_clientId) && StringUtils.isBlank(_clientSecret)) {
                if (this.__isPasswordEncrypted) {
                    _clientSecret = this.__password != null ? this.__password.decrypt(_clientSecret) : ((IPasswordProcessor)this.__owner.getConfig().getDefaultPasswordClass().newInstance()).decrypt(_clientSecret);
                }
                _initCfg = new IOAuthConnectProcessor.ConnectInitCfg(name, _clientId, _clientSecret, _redirectUrl, _attributes);
                this.__connectInitCfgs.put(name, _initCfg);
            }
        }
        return _initCfg;
    }

    @Override
    public IOAuthConnectCallbackHandler getConnectCallbackHandler() {
        return this.__callbackHandler;
    }
}

