/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import com.alibaba.fastjson.JSONObject;
import net.ymate.framework.commons.HttpClientHelper;
import net.ymate.framework.commons.IHttpResponse;
import net.ymate.module.oauth.connector.AbstractOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.module.oauth.connector.annotation.OAuthConnectProcessor;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;

@OAuthConnectProcessor(value="oschina")
public class OSChinaConnectProcessor
extends AbstractOAuthConnectProcessor {
    private static final String __CONNECT_URL = "https://www.oschina.net/action/oauth2/authorize?";
    private static final String __TOKEN_URL = "https://www.oschina.net/action/openapi/token?dataType=json";
    private static final String __USERINFO_URL = "https://www.oschina.net/action/openapi/user?dataType=json&access_token=";

    public OSChinaConnectProcessor() {
        super("uid");
        this.__doSetNeedRedirectUri(true);
    }

    @Override
    public String getAuthorizeUrl(String state) {
        return __CONNECT_URL + this.__doBuildAuthzUrl(null, state, true);
    }

    @Override
    protected Header[] __doGetRequestHeaders() {
        return new Header[]{new BasicHeader("Accept", "application/json"), new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36")};
    }

    @Override
    public OAuthConnectUser getConnectUser(String code) throws Exception {
        IHttpResponse _response;
        JSONObject _result;
        OAuthConnectUser _connectUser = this.__doGetAccessToken(code, __TOKEN_URL);
        if (_connectUser != null && StringUtils.isNotBlank((String)_connectUser.getAccessToken()) && (_result = this.__doParseConnectResponseBody(_response = HttpClientHelper.create().get(__USERINFO_URL.concat(_connectUser.getAccessToken()), this.__doGetRequestHeaders()))) != null) {
            _connectUser.setOpenId(_result.getString("id")).setNickName(_result.getString("name")).setPhotoUrl(_result.getString("avatar"));
            String _gender = _result.getString("gender");
            if (StringUtils.isNotBlank((String)_gender)) {
                _connectUser.setGender(OAuthConnectUser.Gender.valueOf(_gender.toUpperCase()));
            } else {
                _connectUser.setGender(OAuthConnectUser.Gender.UNKNOW);
            }
        }
        return _connectUser;
    }
}

