/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import net.ymate.framework.commons.HttpClientHelper;
import net.ymate.framework.commons.IHttpResponse;
import net.ymate.framework.commons.ParamUtils;
import net.ymate.module.oauth.connector.AbstractOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.module.oauth.connector.annotation.OAuthConnectProcessor;
import org.apache.commons.lang.StringUtils;

@OAuthConnectProcessor(value="qq")
public class QQConnectProcessor
extends AbstractOAuthConnectProcessor {
    private static final String __CONNECT_URL = "https://graph.qq.com/oauth2.0/authorize?";
    private static final String __TOKEN_URL = "https://graph.qq.com/oauth2.0/token?";
    private static final String __OPEN_ID_URL = "https://graph.qq.com/oauth2.0/me?access_token=";
    private static final String __USERINFO_URL = "https://graph.qq.com/user/get_user_info?";
    private static final String M = "\u7537";
    private static final String F = "\u5973";

    public QQConnectProcessor() {
        this.__doSetNeedRedirectUri(true);
    }

    @Override
    public String getAuthorizeUrl(String state) {
        return __CONNECT_URL + this.__doBuildAuthzUrl(null, state, true);
    }

    @Override
    protected OAuthConnectUser __doGetAccessToken(String code, String tokenUrl) throws Exception {
        IHttpResponse _response;
        JSONObject _result;
        OAuthConnectUser _connectUser = super.__doGetAccessToken(code, tokenUrl);
        if (_connectUser != null && (_result = this.__doParseConnectResponseBody(_response = HttpClientHelper.create().get(__OPEN_ID_URL.concat(_connectUser.getAccessToken()), this.__doGetRequestHeaders()))) != null) {
            _connectUser.setOpenId(_result.getString("openid"));
        }
        return _connectUser;
    }

    @Override
    public OAuthConnectUser getConnectUser(String code) throws Exception {
        OAuthConnectUser _connectUser = this.__doGetAccessToken(code, __TOKEN_URL);
        if (_connectUser != null && StringUtils.isNotBlank((String)_connectUser.getAccessToken()) && StringUtils.isNotBlank((String)_connectUser.getOpenId())) {
            HashMap<String, String> _params = new HashMap<String, String>();
            _params.put("access_token", _connectUser.getAccessToken());
            _params.put("oauth_consumer_key", this.__initCfg.getClientId());
            _params.put("openid", _connectUser.getOpenId());
            IHttpResponse _response = HttpClientHelper.create().get(__USERINFO_URL, _params);
            JSONObject _result = super.__doParseConnectResponseBody(_response);
            if (_result != null) {
                int _ret = _result.getIntValue("ret");
                if (_ret == 0) {
                    String _gender;
                    _connectUser.setNickName(_result.getString("nickname")).setPhotoUrl(_result.getString("figureurl_qq_2"));
                    if (StringUtils.isBlank((String)_connectUser.getPhotoUrl())) {
                        _connectUser.setPhotoUrl(_result.getString("figureurl_qq_1"));
                    }
                    if (F.equals(_gender = _result.getString("gender"))) {
                        _connectUser.setGender(OAuthConnectUser.Gender.FEMALE);
                    } else if (M.equals(_gender)) {
                        _connectUser.setGender(OAuthConnectUser.Gender.MALE);
                    } else {
                        _connectUser.setGender(OAuthConnectUser.Gender.UNKNOW);
                    }
                } else {
                    throw new RuntimeException(_result.toJSONString());
                }
            }
        }
        return _connectUser;
    }

    @Override
    protected JSONObject __doParseConnectResponseBody(IHttpResponse response) throws Exception {
        if (response != null && response.getStatusCode() == 200) {
            JSONObject _result = null;
            if (StringUtils.startsWith((String)response.getContent(), (String)"callback")) {
                _result = JSON.parseObject((String)StringUtils.substringBetween((String)response.getContent(), (String)"callback(", (String)");"));
            } else {
                _result = new JSONObject();
                _result.putAll(ParamUtils.parseQueryParamStr((String)response.getContent(), (boolean)true, (String)"UTF-8"));
            }
            if (_result.containsKey((Object)"error")) {
                throw new RuntimeException(_result.toJSONString());
            }
            return _result;
        }
        return null;
    }
}

