/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import net.ymate.framework.commons.HttpClientHelper;
import net.ymate.framework.commons.IHttpResponse;
import net.ymate.module.oauth.connector.AbstractOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.module.oauth.connector.annotation.OAuthConnectProcessor;
import org.apache.commons.lang.StringUtils;

@OAuthConnectProcessor(value="wechat")
public class WeChatConnectProcessor
extends AbstractOAuthConnectProcessor {
    private static final String __CONNECT_URL = "https://open.weixin.qq.com/connect/qrconnect?";
    private static final String __TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String __USERINFO_URL = "https://api.weixin.qq.com/sns/userinfo";

    public WeChatConnectProcessor() {
        super("appid", "secret", "openid");
        this.__doSetErrorFlag("errcode");
    }

    @Override
    public String getAuthorizeUrl(String state) {
        return __CONNECT_URL + this.__doBuildAuthzUrl("snsapi_login", state, true) + "#wechat_redirect";
    }

    @Override
    public OAuthConnectUser getConnectUser(String code) throws Exception {
        OAuthConnectUser _connectUser = this.__doGetAccessToken(code, __TOKEN_URL);
        if (_connectUser != null && StringUtils.isNotBlank((String)_connectUser.getAccessToken()) && StringUtils.isNotBlank((String)_connectUser.getOpenId())) {
            HashMap<String, String> _params = new HashMap<String, String>();
            _params.put("access_token", _connectUser.getAccessToken());
            _params.put("openid", _connectUser.getOpenId());
            IHttpResponse _response = HttpClientHelper.create().get(__USERINFO_URL, _params);
            JSONObject _result = this.__doParseConnectResponseBody(_response);
            if (_result != null) {
                _connectUser.setNickName(_result.getString("nickname")).setPhotoUrl(_result.getString("headimgurl")).setUnionId(_result.getString("unionid"));
                switch (_result.getIntValue("sex")) {
                    case 1: {
                        _connectUser.setGender(OAuthConnectUser.Gender.MALE);
                        break;
                    }
                    case 2: {
                        _connectUser.setGender(OAuthConnectUser.Gender.FEMALE);
                        break;
                    }
                    default: {
                        _connectUser.setGender(OAuthConnectUser.Gender.UNKNOW);
                    }
                }
                _connectUser.putAttribute("country", _result.getString("country"));
                _connectUser.putAttribute("province", _result.getString("province"));
                _connectUser.putAttribute("city", _result.getString("city"));
            }
        }
        return _connectUser;
    }
}

