/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.module.oauth.connector.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import net.ymate.framework.commons.HttpClientHelper;
import net.ymate.framework.commons.IHttpResponse;
import net.ymate.module.oauth.connector.AbstractOAuthConnectProcessor;
import net.ymate.module.oauth.connector.OAuthConnectUser;
import net.ymate.module.oauth.connector.annotation.OAuthConnectProcessor;
import org.apache.commons.lang.StringUtils;

@OAuthConnectProcessor(value="weibo")
public class WeiboConnectProcessor
extends AbstractOAuthConnectProcessor {
    private static final String __CONNECT_URL = "https://api.weibo.com/oauth2/authorize?";
    private static final String __TOKEN_URL = "https://api.weibo.com/oauth2/access_token";
    private static final String __USERINFO_URL = "https://api.weibo.com/2/users/show.json";
    private static final String M = "m";
    private static final String F = "f";

    public WeiboConnectProcessor() {
        super("uid");
        this.__doSetErrorFlag("error_code");
        this.__doSetNeedRedirectUri(true);
    }

    @Override
    public String getAuthorizeUrl(String state) {
        return __CONNECT_URL + this.__doBuildAuthzUrl("email", state, true);
    }

    @Override
    public OAuthConnectUser getConnectUser(String code) throws Exception {
        OAuthConnectUser _connectUser = this.__doGetAccessToken(code, __TOKEN_URL, true);
        if (_connectUser != null && StringUtils.isNotBlank((String)_connectUser.getAccessToken())) {
            HashMap<String, String> _params = new HashMap<String, String>();
            _params.put("access_token", _connectUser.getAccessToken());
            _params.put("uid", _connectUser.getOpenId());
            IHttpResponse _response = HttpClientHelper.create().get(__USERINFO_URL, _params, this.__doGetRequestHeaders());
            JSONObject _result = this.__doParseConnectResponseBody(_response);
            if (_result != null) {
                _connectUser.setNickName(_result.getString("screen_name")).setPhotoUrl(_result.getString("avatar_large"));
                String _gender = _result.getString("gender");
                if (F.equals(_gender)) {
                    _connectUser.setGender(OAuthConnectUser.Gender.FEMALE);
                } else if (M.equals(_gender)) {
                    _connectUser.setGender(OAuthConnectUser.Gender.MALE);
                } else {
                    _connectUser.setGender(OAuthConnectUser.Gender.UNKNOW);
                }
                _connectUser.putAttribute("province", _result.getString("province"));
                _connectUser.putAttribute("city", _result.getString("city"));
                return _connectUser;
            }
        }
        return null;
    }
}

