/*
 * Decompiled with CFR 0.152.
 */
package zygf.jackshaft.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.async.ByteArrayFeeder;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import scala.Predef$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import zygf.jackshaft.conf.JackshaftConfig;
import zygf.jackshaft.conf.TempBufferProvider;
import zygf.jackshaft.impl.JacksonWrapper;
import zygf.jackshaft.impl.ParsingMiddleware;
import zygf.jackshaft.impl.ParsingMode;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\b\u0010\u0005YA\u0001B\b\u0001\u0003\u0006\u0004%\ta\b\u0005\t_\u0001\u0011\t\u0011)A\u0005A!A\u0001\u0007\u0001B\u0001B\u0003-\u0011\u0007C\u00038\u0001\u0011\u0005\u0001\bC\u0004>\u0001\t\u0007I\u0011\u0002 \t\r-\u0003\u0001\u0015!\u0003@\u0011\u001da\u0005A1A\u0005\n5Ca\u0001\u0016\u0001!\u0002\u0013q\u0005bB+\u0001\u0005\u0004%IA\u0016\u0005\u00075\u0002\u0001\u000b\u0011B,\t\u000bm\u0003A\u0011\u0001/\t\u000bM\u0004A\u0011\u0001;\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\t\u0001\")\u001f;f\u0005V4g-\u001a:QCJ\u001cXM\u001d\u0006\u0003!E\tA![7qY*\u0011!cE\u0001\nU\u0006\u001c7n\u001d5bMRT\u0011\u0001F\u0001\u0005uf<gm\u0001\u0001\u0016\u0005]13C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u00069\u0001/\u0019:tS:<W#\u0001\u0011\u0011\u0007\u0005\u0012C%D\u0001\u0010\u0013\t\u0019sBA\tQCJ\u001c\u0018N\\4NS\u0012$G.Z<be\u0016\u0004\"!\n\u0014\r\u0001\u0011)q\u0005\u0001b\u0001Q\t\t!*\u0005\u0002*YA\u0011\u0011DK\u0005\u0003Wi\u0011qAT8uQ&tw\r\u0005\u0002\u001a[%\u0011aF\u0007\u0002\u0004\u0003:L\u0018\u0001\u00039beNLgn\u001a\u0011\u0002\r\r|gNZ5h!\t\u0011T'D\u00014\u0015\t!\u0014#\u0001\u0003d_:4\u0017B\u0001\u001c4\u0005=Q\u0015mY6tQ\u00064GoQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002:yQ\u0011!h\u000f\t\u0004C\u0001!\u0003\"\u0002\u0019\u0005\u0001\b\t\u0004\"\u0002\u0010\u0005\u0001\u0004\u0001\u0013a\u00016bqV\tq\b\u0005\u0002A\u00136\t\u0011I\u0003\u0002C\u0007\u0006!1m\u001c:f\u0015\t!U)A\u0004kC\u000e\\7o\u001c8\u000b\u0005\u0019;\u0015!\u00034bgR,'\u000f_7m\u0015\u0005A\u0015aA2p[&\u0011!*\u0011\u0002\u000b\u0015N|g\u000eU1sg\u0016\u0014\u0018\u0001\u00026bq\u0002\naAZ3fI\u0016\u0014X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u000b\u0015!B1ts:\u001c\u0017BA*Q\u0005=\u0011\u0015\u0010^3BeJ\f\u0017PR3fI\u0016\u0014\u0018a\u00024fK\u0012,'\u000fI\u0001\boJ\f\u0007\u000f]3s+\u00059\u0006cA\u0011YI%\u0011\u0011l\u0004\u0002\u000f\u0015\u0006\u001c7n]8o/J\f\u0007\u000f]3s\u0003!9(/\u00199qKJ\u0004\u0013A\u00039beN,g+\u00197vKR\u0011A%\u0018\u0005\u0006=.\u0001\raX\u0001\u0006S:\u0004X\u000f\u001e\t\u0004A\"\\gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!W#\u0001\u0004=e>|GOP\u0005\u00027%\u0011qMG\u0001\ba\u0006\u001c7.Y4f\u0013\tI'N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t9'\u0004\u0005\u0002mc6\tQN\u0003\u0002o_\u0006\u0019a.[8\u000b\u0003A\fAA[1wC&\u0011!/\u001c\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018A\u00039beN,\u0017i]=oGR)Q/a\u0002\u0002\nQ\u0011a/\u001f\t\u00033]L!\u0001\u001f\u000e\u0003\u000f\t{w\u000e\\3b]\")!\u0010\u0004a\u0001w\u0006A1-\u00197mE\u0006\u001c7\u000e\u0005\u0003}\u0003\u0007!S\"A?\u000b\u0005y|\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007\u0005\u0005q.\u0001\u0003vi&d\u0017bAA\u0003{\nA1i\u001c8tk6,'\u000fC\u0003_\u0019\u0001\u0007q\fC\u0004\u0002\f1\u0001\r!!\u0004\u0002\t5|G-\u001a\t\u0004C\u0005=\u0011bAA\t\u001f\tY\u0001+\u0019:tS:<Wj\u001c3f\u0003-1\u0017N\\5tQ\u0006\u001b\u0018P\\2\u0015\t\u0005]\u0011\u0011\u0005\u000b\u0005\u00033\ty\u0002E\u0002\u001a\u00037I1!!\b\u001b\u0005\u0011)f.\u001b;\t\u000bil\u0001\u0019A>\t\u000f\u0005-Q\u00021\u0001\u0002\u000e\u0001")
public final class ByteBufferParser<J> {
    private final ParsingMiddleware<J> parsing;
    private final JackshaftConfig config;
    private final JsonParser jax;
    private final ByteArrayFeeder feeder;
    private final JacksonWrapper<J> wrapper;

    public ParsingMiddleware<J> parsing() {
        return this.parsing;
    }

    private JsonParser jax() {
        return this.jax;
    }

    private ByteArrayFeeder feeder() {
        return this.feeder;
    }

    private JacksonWrapper<J> wrapper() {
        return this.wrapper;
    }

    /*
     * WARNING - void declaration
     */
    public J parseValue(Iterator<ByteBuffer> input) {
        while (input.hasNext()) {
            void var9_9;
            block6: {
                ByteBuffer bb = (ByteBuffer)input.next();
                if (bb.hasArray()) {
                    int off = bb.arrayOffset();
                    this.feeder().feedInput(bb.array(), off + bb.position(), off + bb.limit());
                    J result = this.wrapper().parseValue(this.jax());
                    if (result == null) continue;
                    return result;
                }
                TempBufferProvider bufferProvider = this.config.tempBufferProvider();
                byte[] buf = bufferProvider.acquire();
                try {
                    int chunk;
                    for (int left = bb.remaining(); left > 0; left -= chunk) {
                        chunk = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(left), buf.length);
                        bb.get(buf, 0, chunk);
                        this.feeder().feedInput(buf, 0, chunk);
                        J result = this.wrapper().parseValue(this.jax());
                        if (result == null) continue;
                        break block6;
                    }
                    continue;
                }
                finally {
                    bufferProvider.release(buf);
                    continue;
                }
            }
            return var9_9;
        }
        this.feeder().endOfInput();
        return this.wrapper().parseValue(this.jax());
    }

    public boolean parseAsync(Iterator<ByteBuffer> input, ParsingMode mode, Consumer<J> callback) {
        while (input.hasNext()) {
            boolean bl;
            block6: {
                ByteBuffer bb = (ByteBuffer)input.next();
                if (bb.hasArray()) {
                    int off = bb.arrayOffset();
                    this.feeder().feedInput(bb.array(), off + bb.position(), off + bb.limit());
                    if (!this.wrapper().parseAsync(this.jax(), mode, callback)) continue;
                    return true;
                }
                TempBufferProvider bufferProvider = this.config.tempBufferProvider();
                byte[] buf = bufferProvider.acquire();
                try {
                    int chunk;
                    for (int left = bb.remaining(); left > 0; left -= chunk) {
                        chunk = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(left), buf.length);
                        bb.get(buf, 0, chunk);
                        this.feeder().feedInput(buf, 0, chunk);
                        if (!this.wrapper().parseAsync(this.jax(), mode, callback)) continue;
                        bl = true;
                        break block6;
                    }
                    continue;
                }
                finally {
                    bufferProvider.release(buf);
                    continue;
                }
            }
            return bl;
        }
        return false;
    }

    public void finishAsync(ParsingMode mode, Consumer<J> callback) {
        this.feeder().endOfInput();
        this.wrapper().parseAsync(this.jax(), mode, callback);
    }

    public ByteBufferParser(ParsingMiddleware<J> parsing, JackshaftConfig config) {
        this.parsing = parsing;
        this.config = config;
        this.jax = config.jacksonFactory().createNonBlockingByteArrayParser();
        this.feeder = (ByteArrayFeeder)this.jax().getNonBlockingInputFeeder();
        this.wrapper = parsing.createJacksonWrapper(config);
    }
}

