/*
 * Decompiled with CFR 0.152.
 */
package zygf.jackshaft.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Consumer;
import zygf.jackshaft.exceptions.ArrayExpectedException;
import zygf.jackshaft.exceptions.UnexpectedEndOfInputException$;
import zygf.jackshaft.impl.JacksonWrapper;
import zygf.jackshaft.impl.ParsingMiddlewareImpl;
import zygf.jackshaft.impl.ParsingMode;

public class JacksonWrapperImpl<J, A, M>
extends JacksonWrapper<J> {
    private final ParsingMiddlewareImpl<J, A, M> middleware;
    private final int maxDepth;
    private byte[] states;
    private String[] keys;
    private J[] vals;
    private A[] arrays;
    private M[] maps;
    private int depth;

    public JacksonWrapperImpl(ParsingMiddlewareImpl<J, A, M> parsingMiddlewareImpl, Class<J> clazz) {
        this(parsingMiddlewareImpl, clazz, 4, 64);
    }

    public JacksonWrapperImpl(ParsingMiddlewareImpl<J, A, M> parsingMiddlewareImpl, Class<J> clazz, int n, int n2) {
        this.maxDepth = n2;
        this.middleware = parsingMiddlewareImpl;
        this.maps = new Object[n];
        this.arrays = new Object[n];
        this.states = new byte[n];
        this.keys = new String[n * 4];
        this.vals = (Object[])Array.newInstance(clazz, n * 4);
        this.depth = -1;
    }

    public void reset() {
        Arrays.fill(this.arrays, null);
        Arrays.fill(this.maps, null);
        Arrays.fill(this.keys, null);
        Arrays.fill(this.vals, null);
        Arrays.fill(this.states, (byte)0);
        this.depth = -1;
    }

    private void grow() {
        int n = this.arrays.length;
        int n2 = this.maxDepth;
        if (n == n2) {
            throw new IllegalStateException("Recursion limit reached.");
        }
        if ((n *= 2) > n2) {
            n = n2;
        }
        this.arrays = Arrays.copyOf(this.arrays, n);
        this.maps = Arrays.copyOf(this.maps, n);
        this.keys = Arrays.copyOf(this.keys, n * 4);
        this.vals = Arrays.copyOf(this.vals, n * 4);
        this.states = Arrays.copyOf(this.states, n);
    }

    @Override
    public J parseValue(JsonParser jsonParser) throws IOException {
        Object j;
        A[] AArray = this.arrays;
        M[] MArray = this.maps;
        byte[] byArray = this.states;
        String[] stringArray = this.keys;
        J[] JArray = this.vals;
        int n = this.depth;
        int n2 = this.arrays.length;
        ParsingMiddlewareImpl<J, A, M> parsingMiddlewareImpl = this.middleware;
        block23: while (true) {
            int n3;
            JsonToken jsonToken;
            if ((jsonToken = jsonParser.nextToken()) == null) {
                if (n >= 0 && byArray[0] < 8) {
                    throw UnexpectedEndOfInputException$.MODULE$;
                }
                this.depth = -2;
                return null;
            }
            int n4 = 0;
            j = null;
            switch (jsonToken) {
                case NOT_AVAILABLE: {
                    return null;
                }
                case START_ARRAY: {
                    n4 = 6;
                }
                case START_OBJECT: {
                    this.depth = ++n;
                    if (n >= n2) {
                        this.grow();
                        AArray = this.arrays;
                        MArray = this.maps;
                        byArray = this.states;
                        stringArray = this.keys;
                        JArray = this.vals;
                        n2 = this.arrays.length;
                    }
                    byArray[n] = n4;
                    continue block23;
                }
                case END_ARRAY: {
                    if (AArray[n] == null) {
                        j = parsingMiddlewareImpl.buildArray();
                    } else {
                        j = parsingMiddlewareImpl.buildArray(AArray[n]);
                        AArray[n] = null;
                    }
                    this.depth = --n;
                    break;
                }
                case FIELD_NAME: {
                    if (byArray[n] >= 4) continue block23;
                    stringArray[n * 4 + byArray[n]] = jsonParser.getCurrentName();
                    continue block23;
                }
                case END_OBJECT: {
                    n3 = n * 4;
                    switch (byArray[n]) {
                        case 0: {
                            j = parsingMiddlewareImpl.buildObject();
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            j = parsingMiddlewareImpl.buildObject(stringArray, JArray, n3, byArray[n]);
                            break;
                        }
                        default: {
                            j = parsingMiddlewareImpl.buildObject(MArray[n]);
                        }
                    }
                    MArray[n] = null;
                    this.depth = --n;
                    break;
                }
                case VALUE_NULL: {
                    j = parsingMiddlewareImpl.buildNull();
                    break;
                }
                case VALUE_TRUE: {
                    j = parsingMiddlewareImpl.buildTrue();
                    break;
                }
                case VALUE_FALSE: {
                    j = parsingMiddlewareImpl.buildFalse();
                    break;
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    j = parsingMiddlewareImpl.buildNumber(jsonParser.getNumberValue());
                    break;
                }
                case VALUE_STRING: {
                    j = jsonParser.getTextLength() == 0 ? (Object)parsingMiddlewareImpl.buildString("") : (Object)parsingMiddlewareImpl.buildString(jsonParser.getText());
                }
            }
            if (n < 0) {
                if (byArray[0] >= 7) {
                    return null;
                }
                this.reset();
                return j;
            }
            switch (byArray[n]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    JArray[n * 4 + byArray[n]] = j;
                    int n5 = n;
                    byArray[n5] = (byte)(byArray[n5] + 1);
                    continue block23;
                }
                case 4: {
                    n3 = n * 4;
                    MArray[n] = parsingMiddlewareImpl.growMap(parsingMiddlewareImpl.growMap(parsingMiddlewareImpl.growMap(parsingMiddlewareImpl.growMap(parsingMiddlewareImpl.emptyMap(), stringArray[n3], JArray[n3++]), stringArray[n3], JArray[n3++]), stringArray[n3], JArray[n3++]), stringArray[n3], JArray[n3]);
                    byArray[n] = 5;
                }
                case 5: {
                    MArray[n] = parsingMiddlewareImpl.growMap(MArray[n], jsonParser.getCurrentName(), j);
                    continue block23;
                }
                case 6: {
                    if (AArray[n] == null) {
                        AArray[n] = parsingMiddlewareImpl.emptyArray();
                    }
                    AArray[n] = parsingMiddlewareImpl.growArray(AArray[n], j);
                    continue block23;
                }
            }
            break;
        }
        return j;
    }

    @Override
    public boolean parseAsync(JsonParser jsonParser, ParsingMode parsingMode, Consumer<J> consumer) throws IOException {
        switch (parsingMode) {
            case VALUE: {
                if (this.depth != -2) {
                    J j = this.parseValue(jsonParser);
                    if (j != null) {
                        consumer.accept(j);
                        this.depth = -2;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            case ARRAY: {
                return this.parseArray(jsonParser, consumer);
            }
            case STREAM: {
                this.parseStream(jsonParser, consumer);
                return this.depth == -2;
            }
        }
        return true;
    }

    @Override
    public boolean parseArray(JsonParser jsonParser, Consumer<J> consumer) throws IOException {
        J j;
        if (this.depth < 0) {
            if (this.states[0] == 7) {
                return true;
            }
            switch (jsonParser.nextToken()) {
                case NOT_AVAILABLE: {
                    return false;
                }
                case START_ARRAY: {
                    break;
                }
                default: {
                    throw new ArrayExpectedException("JSON array expected but first token was: " + jsonParser.currentToken().toString());
                }
            }
            ++this.depth;
            this.states[this.depth] = 7;
        }
        while ((j = this.parseValue(jsonParser)) != null) {
            consumer.accept(j);
        }
        return this.depth < 0;
    }

    @Override
    public void parseStream(JsonParser jsonParser, Consumer<J> consumer) throws IOException {
        J j;
        if (this.depth == -2) {
            return;
        }
        if (this.depth == -1) {
            this.depth = 0;
            this.states[this.depth] = 8;
        }
        while ((j = this.parseValue(jsonParser)) != null) {
            consumer.accept(j);
        }
    }
}

