/*
 * Decompiled with CFR 0.152.
 */
package zygf.jackshaft.impl.akka;

import akka.NotUsed;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypeRange;
import akka.http.scaladsl.model.ContentTypeRange$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.MediaTypes$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.http.scaladsl.util.FastFuture$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import zygf.jackshaft.conf.JackshaftConfig;
import zygf.jackshaft.exceptions.PrintingException;
import zygf.jackshaft.exceptions.UnexpectedEndOfInputException$;
import zygf.jackshaft.impl.ByteBufferParser;
import zygf.jackshaft.impl.JsonPrinter;
import zygf.jackshaft.impl.ParsingMiddleware;
import zygf.jackshaft.impl.PrintingMiddleware;
import zygf.jackshaft.impl.akka.JsonParserStage;
import zygf.jackshaft.impl.akka.JsonPrinterStage;
import zygf.jackshaft.impl.akka.StreamingJsonParserStage;
import zygf.jackshaft.impl.akka.StreamingJsonPrinterStage;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!\u0002\b\u0010\u0003\u0003A\u0002\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011A\u0011\t\u0011E\u0002!\u0011!Q\u0001\n\tB\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\to\u0001\u0011\t\u0011)A\u0005i!)\u0001\b\u0001C\u0001s!)a\b\u0001C\t\u007f!)\u0001\f\u0001C\t3\")a\f\u0001C\t?\")\u0011\u0010\u0001C\tu\"9\u0011Q\u0002\u0001\u0005\u0012\u0005=\u0001bBA\r\u0001\u0011E\u00111\u0004\u0005\b\u0003K\u0001A\u0011CA\u0014\u0011\u001d\t\u0019\u0005\u0001C\t\u0003\u000b\u00121\"Q6lCN+\b\u000f]8si*\u0011\u0001#E\u0001\u0005C.\\\u0017M\u0003\u0002\u0013'\u0005!\u0011.\u001c9m\u0015\t!R#A\u0005kC\u000e\\7\u000f[1gi*\ta#\u0001\u0003{s\u001e47\u0001A\u000b\u00033!\u001a\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0001\u0018M]:j]\u001e,\u0012A\t\t\u0004G\u00112S\"A\t\n\u0005\u0015\n\"!\u0005)beNLgnZ'jI\u0012dWm^1sKB\u0011q\u0005\u000b\u0007\u0001\t\u0015I\u0003A1\u0001+\u0005\u0005Q\u0015CA\u0016/!\tYB&\u0003\u0002.9\t9aj\u001c;iS:<\u0007CA\u000e0\u0013\t\u0001DDA\u0002B]f\f\u0001\u0002]1sg&tw\rI\u0001\taJLg\u000e^5oOV\tA\u0007E\u0002$k\u0019J!AN\t\u0003%A\u0013\u0018N\u001c;j]\u001el\u0015\u000e\u001a3mK^\f'/Z\u0001\naJLg\u000e^5oO\u0002\na\u0001P5oSRtDc\u0001\u001e={A\u00191\b\u0001\u0014\u000e\u0003=AQ\u0001I\u0003A\u0002\tBQAM\u0003A\u0002Q\n1\u0002]1sg\u0016\u001cFO]5diR\u0011\u0001i\u0014\u000b\u0003\u0003\u001e\u00032AQ#'\u001b\u0005\u0019%B\u0001#\u001d\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\r\u000e\u0013aAR;ukJ,\u0007\"\u0002%\u0007\u0001\bI\u0015AB2p]\u001aLw\r\u0005\u0002K\u001b6\t1J\u0003\u0002M'\u0005!1m\u001c8g\u0013\tq5JA\bKC\u000e\\7\u000f[1gi\u000e{gNZ5h\u0011\u0015\u0001f\u00011\u0001R\u0003\u0015Ig\u000e];u!\t\u0011f+D\u0001T\u0015\t!V+\u0001\u0003vi&d'\"\u0001\t\n\u0005]\u001b&A\u0003\"zi\u0016\u001cFO]5oO\u0006Y\u0001O]5oiN#(/[2u)\tQF\f\u0006\u0002R7\")\u0001j\u0002a\u0002\u0013\")Ql\u0002a\u0001M\u0005!!n]8o\u0003i1'o\\7CsR,7\u000b\u001e:j]\u001e,f.\\1sg\"\fG\u000e\\3s)\t\u0001\u0007\u0010E\u0002bk\u001ar!A\u0019:\u000f\u0005\r|gB\u00013m\u001d\t)'N\u0004\u0002gS6\tqM\u0003\u0002i/\u00051AH]8pizJ\u0011\u0001E\u0005\u0003WV\u000bA\u0001\u001b;ua&\u0011QN\\\u0001\tg\u000e\fG.\u00193tY*\u00111.V\u0005\u0003aF\fQ\"\u001e8nCJ\u001c\b.\u00197mS:<'BA7o\u0013\t\u0019H/A\u0004qC\u000e\\\u0017mZ3\u000b\u0005A\f\u0018B\u0001<x\u0005i1%o\\7CsR,7\u000b\u001e:j]\u001e,f.\\1sg\"\fG\u000e\\3s\u0015\t\u0019H\u000fC\u0003I\u0011\u0001\u000f\u0011*\u0001\fu_\nKH/Z*ue&tw-T1sg\"\fG\u000e\\3s)\rY\u00181\u0002\t\u0005y\u0006\u0015aED\u0002~\u0003\u0003q!a\u0019@\n\u0005}\f\u0018aC7beND\u0017\r\u001c7j]\u001eL1a]A\u0002\u0015\ty\u0018/\u0003\u0003\u0002\b\u0005%!A\u0006+p\u0005f$Xm\u0015;sS:<W*\u0019:tQ\u0006dG.\u001a:\u000b\u0007M\f\u0019\u0001C\u0003I\u0013\u0001\u000f\u0011*\u0001\fge>lWI\u001c;jif,f.\\1sg\"\fG\u000e\\3s)\u0011\t\t\"a\u0006\u0011\t\u0005\f\u0019BJ\u0005\u0004\u0003+9(A\u0006$s_6,e\u000e^5usVsW.\u0019:tQ\u0006dG.\u001a:\t\u000b!S\u00019A%\u0002%Q|WI\u001c;jifl\u0015M]:iC2dWM\u001d\u000b\u0005\u0003;\t\u0019\u0003\u0005\u0003}\u0003?1\u0013\u0002BA\u0011\u0003\u0013\u0011!\u0003V8F]RLG/_'beND\u0017\r\u001c7fe\")\u0001j\u0003a\u0002\u0013\u0006a2o\\;sG\u00164%o\\7F]RLG/_+o[\u0006\u00148\u000f[1mY\u0016\u0014H\u0003BA\u0015\u0003\u0003\u0002R!YA\n\u0003W\u0001r!!\f\u00026\u0019\nI$\u0004\u0002\u00020)\u0019Q.!\r\u000b\u0007\u0005MR+\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003o\tyC\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003w\ti$D\u0001V\u0013\r\ty$\u0016\u0002\b\u001d>$Xk]3e\u0011\u0015AE\u0002q\u0001J\u0003a\u0019x.\u001e:dKR{WI\u001c;jifl\u0015M]:iC2dWM\u001d\u000b\u0005\u0003\u000f\nI\u0005E\u0003}\u0003?\tY\u0003C\u0003I\u001b\u0001\u000f\u0011\n")
public abstract class AkkaSupport<J> {
    private final ParsingMiddleware<J> parsing;
    private final PrintingMiddleware<J> printing;

    public ParsingMiddleware<J> parsing() {
        return this.parsing;
    }

    public PrintingMiddleware<J> printing() {
        return this.printing;
    }

    public Future<J> parseStrict(ByteString input, JackshaftConfig config) {
        J json = new ByteBufferParser<J>(this.parsing(), config).parseValue((Iterator<ByteBuffer>)input.asByteBuffers().iterator());
        if (json == null) {
            return (Future)FastFuture$.MODULE$.failed().apply((Object)UnexpectedEndOfInputException$.MODULE$);
        }
        return (Future)FastFuture$.MODULE$.successful().apply(json);
    }

    public ByteString printStrict(J json, JackshaftConfig config) {
        ByteString byteString;
        JsonPrinter<J> printer = new JsonPrinter<J>(this.printing());
        byte[] buf = config.tempBufferProvider().acquire();
        try {
            ByteString bs = ByteString$.MODULE$.empty();
            int offset = printer.start(buf, 0, json);
            boolean done = false;
            while (!done) {
                int nOffset = printer.continue(buf, offset);
                if (nOffset < 0) {
                    done = true;
                    continue;
                }
                if (nOffset > offset) {
                    offset = nOffset;
                    continue;
                }
                bs = bs.$plus$plus(ByteString$.MODULE$.fromArray(buf, 0, nOffset));
                offset = 0;
            }
            if (printer.errors() != Nil$.MODULE$) {
                throw new PrintingException((String)printer.errors().head());
            }
            if (offset > 0) {
                bs = bs.$plus$plus(ByteString$.MODULE$.fromArray(buf, 0, offset));
            }
            byteString = bs;
        }
        finally {
            config.tempBufferProvider().release(buf);
        }
        return byteString;
    }

    public Unmarshaller<ByteString, J> fromByteStringUnmarshaller(JackshaftConfig config) {
        return Unmarshaller$.MODULE$.withMaterializer((Function1 & Serializable)ec -> (Function1 & Serializable)mat -> (Function1 & Serializable)input -> this.parseStrict((ByteString)input, config));
    }

    public Marshaller<J, ByteString> toByteStringMarshaller(JackshaftConfig config) {
        return Marshaller$.MODULE$.withFixedContentType((ContentType)ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), (Function1 & Serializable)json -> this.printStrict(json, config));
    }

    public Unmarshaller<HttpEntity, J> fromEntityUnmarshaller(JackshaftConfig config) {
        return Unmarshaller.EnhancedFromEntityUnmarshaller$.MODULE$.forContentTypes$extension(Unmarshaller$.MODULE$.EnhancedFromEntityUnmarshaller(Unmarshaller$.MODULE$.withMaterializer((Function1 & Serializable)ec -> (Function1 & Serializable)mat -> (Function1 & Serializable)x0$1 -> {
            if (x0$1 instanceof HttpEntity.Strict) {
                ByteString input = ((HttpEntity.Strict)x0$1).data();
                return this.parseStrict(input, config);
            }
            return (Future)x0$1.dataBytes().runWith(new JsonParserStage(this.parsing(), config), mat);
        })), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ContentTypeRange[]{ContentTypeRange$.MODULE$.apply((MediaType)MediaTypes$.MODULE$.application$divjson())}));
    }

    public Marshaller<J, RequestEntity> toEntityMarshaller(JackshaftConfig config) {
        return Marshaller$.MODULE$.withFixedContentType((ContentType)ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), (Function1 & Serializable)json -> HttpEntity$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), Source$.MODULE$.fromGraph(new JsonPrinterStage<Object>(json, this.printing(), config))));
    }

    public Unmarshaller<HttpEntity, Source<J, NotUsed>> sourceFromEntityUnmarshaller(JackshaftConfig config) {
        return Unmarshaller$.MODULE$.withMaterializer((Function1 & Serializable)ec -> (Function1 & Serializable)mat -> (Function1 & Serializable)entity -> {
            Source source = entity.dataBytes().viaMat(new StreamingJsonParserStage(this.parsing(), config), Keep$.MODULE$.right());
            return (Future)FastFuture$.MODULE$.successful().apply((Object)source);
        });
    }

    public Marshaller<Source<J, NotUsed>, RequestEntity> sourceToEntityMarshaller(JackshaftConfig config) {
        return Marshaller$.MODULE$.withFixedContentType((ContentType)ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), (Function1 & Serializable)jsons -> HttpEntity$.MODULE$.apply((ContentType)ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divjson()), jsons.via(new StreamingJsonPrinterStage(this.printing(), config))));
    }

    public AkkaSupport(ParsingMiddleware<J> parsing, PrintingMiddleware<J> printing) {
        this.parsing = parsing;
        this.printing = printing;
    }
}

