/*
 * Decompiled with CFR 0.152.
 */
package zygf.jackshaft.spray;

import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import spray.json.JsArray;
import spray.json.JsBoolean;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsObject;
import spray.json.JsString;
import spray.json.JsValue;
import zygf.jackshaft.conf.JackshaftConfig;
import zygf.jackshaft.impl.JsonPrinter;
import zygf.jackshaft.impl.PrintingMiddleware;

public final class SprayPrinter$
extends PrintingMiddleware<JsValue> {
    public static final SprayPrinter$ MODULE$ = new SprayPrinter$();

    /*
     * WARNING - void declaration
     */
    @Override
    public int emit(JsValue json, JsonPrinter<JsValue> print, byte[] buffer, int offset) {
        if (json == null) {
            print.reportError("null value");
            return print.printNull(buffer, offset);
        }
        if (json instanceof JsString) {
            JsString jsString = (JsString)json;
            if (jsString.value() != null) {
                return print.printString(buffer, offset, jsString.value());
            }
            print.reportError("null string");
            return print.printNull(buffer, offset);
        }
        if (json instanceof JsObject) {
            JsObject jsObject = (JsObject)json;
            if (jsObject.fields() != null) {
                void printObject_values;
                Map map = jsObject.fields();
                if (print == null) {
                    throw null;
                }
                if (printObject_values.isEmpty()) {
                    buffer[offset] = 123;
                    int printObject_printEmptyObject_zygf$jackshaft$impl$JsonPrinter$$emitEndObject_offset = offset + 1;
                    buffer[printObject_printEmptyObject_zygf$jackshaft$impl$JsonPrinter$$emitEndObject_offset] = 125;
                    return printObject_printEmptyObject_zygf$jackshaft$impl$JsonPrinter$$emitEndObject_offset + 1;
                }
                return print.printObject(buffer, offset, (Iterator<Tuple2<String, JsValue>>)printObject_values.iterator());
            }
            print.reportError("null object fields");
            return print.printNull(buffer, offset);
        }
        if (json instanceof JsArray) {
            JsArray jsArray = (JsArray)json;
            if (jsArray.elements() != null) {
                void printArray_values;
                Vector vector = jsArray.elements();
                if (print == null) {
                    throw null;
                }
                if (printArray_values.isEmpty()) {
                    buffer[offset] = 91;
                    int printArray_printEmptyArray_zygf$jackshaft$impl$JsonPrinter$$emitEndArray_offset = offset + 1;
                    buffer[printArray_printEmptyArray_zygf$jackshaft$impl$JsonPrinter$$emitEndArray_offset] = 93;
                    return printArray_printEmptyArray_zygf$jackshaft$impl$JsonPrinter$$emitEndArray_offset + 1;
                }
                return print.printArray(buffer, offset, (Iterator<JsValue>)printArray_values.iterator());
            }
            print.reportError("null array elements");
            return print.printNull(buffer, offset);
        }
        if (json instanceof JsNumber) {
            JsNumber jsNumber = (JsNumber)json;
            if (jsNumber.value() != null) {
                return print.printRaw(buffer, offset, jsNumber.value().bigDecimal().toString());
            }
            print.reportError("null number");
            return print.printNull(buffer, offset);
        }
        if (json instanceof JsBoolean) {
            void printBoolean_value;
            JsBoolean jsBoolean = (JsBoolean)json;
            boolean bl = jsBoolean.value();
            if (print == null) {
                throw null;
            }
            if (printBoolean_value != false) {
                return print.printTrue(buffer, offset);
            }
            return print.printFalse(buffer, offset);
        }
        if (JsNull$.MODULE$.equals(json)) {
            return print.printNull(buffer, offset);
        }
        print.reportError(new StringBuilder(19).append("unrecognized type: ").append(json.getClass().getName()).toString());
        return print.printNull(buffer, offset);
    }

    @Override
    public String printString(JsValue json, JackshaftConfig config) {
        int n;
        if (json instanceof JsArray) {
            JsArray jsArray = (JsArray)json;
            n = 16 * jsArray.elements().size();
        } else if (json instanceof JsObject) {
            JsObject jsObject = (JsObject)json;
            n = 32 * jsObject.fields().size();
        } else if (json instanceof JsString) {
            JsString jsString = (JsString)json;
            n = 2 * jsString.value().length();
        } else {
            n = 16;
        }
        int bufferSize = n;
        return this.printString(json, bufferSize, config);
    }

    private SprayPrinter$() {
    }
}

