package com.phantom.adapter.model

import androidx.annotation.Keep
import com.connect.common.model.Account
import com.connect.common.utils.PrefUtils
import com.particle.base.utils.GsonUtils

@Keep
data class AccountInfo(
    val publicKey: String,
    val secretKey: String,

    var address: String = "",
    var session: String = "",
    var otherPublicKey: String = "",
) {
    fun connected(address: String, session: String, otherPublicKey: String) {
        this.address = address
        this.session = session
        this.otherPublicKey = otherPublicKey
    }

    override fun toString(): String {
        return GsonUtils.toJson(this)
    }

}

@Keep
data class AccountsInfo(
    val accounts: MutableList<AccountInfo>
)

object AccountDao {
    private const val accountKey = "accountKey"
    private fun getAccounts(): MutableList<AccountInfo> {
        try {
            val data = PrefUtils.getSettingString(accountKey)
            val accountInfo = GsonUtils.fromJson(data, AccountsInfo::class.java)
            if (accountInfo != null) {
                return accountInfo.accounts
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
        return ArrayList()
    }

    fun getAdapterAccount(): List<Account> {
        val accounts = getAccounts()
        val adapterAccount = mutableListOf<Account>()
        accounts.forEach {
            if (it.address.isNotEmpty()) {
                adapterAccount.add(Account(it.address))
            }
        }
        return adapterAccount
    }

    fun getAccount(publicKey: String): AccountInfo? {
        val accounts = getAccounts()
        for (account in accounts) {
            if (account.address == publicKey) {
                return account
            }
        }
        return null
    }

    fun delAccount(address: String) {
        val accounts = getAccounts()
        val newAccounts = accounts.filter { it.address != address }
        saveAccounts(AccountsInfo(newAccounts as MutableList<AccountInfo>))
    }

    fun addAccount(accountInfo: AccountInfo) {
        delAccount(accountInfo.address)
        val accounts = getAccounts()

        accounts.add(accountInfo)
        saveAccounts(AccountsInfo(accounts))
    }

    private fun saveAccounts(accounts: AccountsInfo) {
        val json = GsonUtils.toJson(accounts)
        PrefUtils.setSettingString(accountKey, json)
    }

}
