package com.phantom.adapter.tools

import androidx.annotation.Keep
import com.iwebpp.crypto.TweetNaclFast
import com.iwebpp.crypto.TweetNaclFast.randombytes
import com.particle.base.utils.Base58Utils

data class PhantomKeyPair(val publicKey: String, val secretKey: String)

@Keep
object TweetNacl {

    fun generateKeyPair(): PhantomKeyPair {
        val keyPair = TweetNaclFast.Box.keyPair()
        return PhantomKeyPair(Base58Utils.encode(keyPair.publicKey), Base58Utils.encode(keyPair.secretKey))
    }


    fun getBox(otherPublicKey: String, secretKey: String): TweetNaclFast.Box {
        val box = TweetNaclFast.Box(
            Base58Utils.decode(otherPublicKey),
            Base58Utils.decode(secretKey)
        )
        return box
    }


    fun getSharedBox(otherPublicKey: String, secretKey: String): TweetNaclFast.SecretBox {
        val box = TweetNaclFast.Box(
            Base58Utils.decode(otherPublicKey),
            Base58Utils.decode(secretKey)
        )
        return TweetNaclFast.SecretBox(box.before())
    }

    fun getNonce(): String {
        val nonceBytes = ByteArray(24)
        val nonce = randombytes(nonceBytes, 24)
        return Base58Utils.encode(nonce)
    }
}