package com.particle.connect.model

import com.connect.common.IConnectAdapter
import com.connect.common.model.Account
import com.particle.base.ParticleNetwork
import com.particle.base.model.SmartAccountInfo

/**
 * Created by chaichuanfa on 2022/7/26
 */
data class AdapterAccount(val connectAdapter: IConnectAdapter, val accounts: List<Account>)

suspend fun AdapterAccount.getSmartAccounts(): List<SmartAccountInfo> {
    val pubAddresses = accounts.map { it.publicAddress }
    return ParticleNetwork.getAAService().getSmartAccounts(pubAddresses)
}
