/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Property;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.exception.ODataException;

class MockDataGenerator {
    protected static final int RECORD_COUNT = 50;
    protected final Edm edm;
    protected final EdmProvider edmProvider;
    protected final Map<String, EntitySet> entitySets = new HashMap<String, EntitySet>();
    protected final Map<EdmEntityType, EntityType> etClient2Prov = new HashMap<EdmEntityType, EntityType>();

    MockDataGenerator(@NonNull Edm edm, @NonNull EdmProvider edmProvider) throws EdmException, ODataException {
        if (edm == null) {
            throw new NullPointerException("edm is marked non-null but is null");
        }
        if (edmProvider == null) {
            throw new NullPointerException("edmProvider is marked non-null but is null");
        }
        this.edm = edm;
        this.edmProvider = edmProvider;
        for (Schema edmSchema : edmProvider.getSchemas()) {
            for (EntityContainer edmContainer : edmSchema.getEntityContainers()) {
                for (EntitySet provES : edmContainer.getEntitySets()) {
                    this.entitySets.put(provES.getName(), provES);
                    EdmEntitySet clientES = edm.getDefaultEntityContainer().getEntitySet(provES.getName());
                    EntityType provET = edmProvider.getEntityType(provES.getEntityType());
                    this.etClient2Prov.put(clientES.getEntityType(), provET);
                }
            }
        }
    }

    public List<Map<String, Object>> generate(String entitySet) throws EdmException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(50);
        EdmEntityType entityType = this.edm.getDefaultEntityContainer().getEntitySet(entitySet).getEntityType();
        for (int i = 1; i <= 50; ++i) {
            result.add(this.generateRecord(entityType, i));
        }
        return result;
    }

    public Map<String, Object> generateRecord(EdmEntityType entityType, int index) throws EdmException {
        int fieldCount = entityType.getPropertyNames().size();
        HashMap<String, Object> fields = new HashMap<String, Object>(fieldCount);
        EntityType provET = this.etClient2Prov.get(entityType);
        Map<String, Property> provProps = provET.getProperties().parallelStream().collect(Collectors.toMap(e -> e.getName(), e -> e));
        for (String name : entityType.getPropertyNames()) {
            EdmType edmType = entityType.getProperty(name).getType();
            if (!(edmType instanceof EdmSimpleType)) continue;
            EdmFacets facets = provProps.get(name).getFacets();
            fields.put(name, this.generateValue(name, (EdmSimpleType)edmType, facets, index));
        }
        return fields;
    }

    public Object generateValue(String fieldName, EdmSimpleType edmType, EdmFacets facets, int index) throws EdmException {
        String strVal;
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, index - 25);
        switch (edmType.toString()) {
            case "Edm.Binary": {
                strVal = Base64.encodeBase64String((byte[])String.format("%s %d", fieldName, index).getBytes());
                break;
            }
            case "Edm.Boolean": {
                strVal = Boolean.valueOf(Math.random() > 0.5).toString();
                break;
            }
            case "Edm.Byte": {
                strVal = Integer.toString(index % 255);
                break;
            }
            case "Edm.DateTime": {
                strVal = String.format("/Date(%d)/", calendar.getTimeInMillis());
                break;
            }
            case "Edm.DateTimeOffset": {
                strVal = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(calendar.getTime());
                break;
            }
            case "Edm.Decimal": 
            case "Edm.Double": 
            case "Edm.Single": {
                BigDecimal val = new BigDecimal(index);
                if (facets != null && facets.getScale() != null) {
                    val.setScale(facets.getScale());
                }
                strVal = val.toPlainString();
                break;
            }
            case "Edm.Guid": {
                strVal = String.format("%8d-%4d-%4d-%4d-%12d", index, index, index, index, index).replace(' ', '0');
                break;
            }
            case "Edm.Int16": 
            case "Edm.Int32": 
            case "Edm.Int64": {
                strVal = String.format("%d", index);
                break;
            }
            case "Edm.SByte": {
                strVal = Integer.toString(index % 128);
                break;
            }
            case "Edm.String": {
                String indexStr = String.format(" %d", index);
                String namePrefix = fieldName;
                if (facets != null && facets.getMaxLength() != null && namePrefix.length() + indexStr.length() > facets.getMaxLength()) {
                    namePrefix = fieldName.substring(0, facets.getMaxLength() - indexStr.length());
                }
                strVal = namePrefix + indexStr;
                break;
            }
            case "Edm.Time": {
                strVal = String.format("PT%dH00M", index);
                break;
            }
            default: {
                throw new EdmException(EdmException.TYPEPROBLEM.addContent(new Object[]{edmType.toString()}));
            }
        }
        return edmType.valueOfString(strVal, EdmLiteralKind.JSON, facets, edmType.getDefaultType());
    }
}

