/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import ninja.abap.odatamock.server.MockDataStore;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataSource;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;

class MockDataSource
implements DataSource {
    protected final EdmProvider edmProvider;
    protected final MockDataStore dataStore;

    MockDataSource(@NonNull EdmProvider edmProvider) throws ODataException {
        if (edmProvider == null) {
            throw new NullPointerException("edmProvider is marked non-null but is null");
        }
        this.edmProvider = edmProvider;
        this.dataStore = new MockDataStore(edmProvider);
    }

    public List<?> readData(EdmEntitySet entitySet) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        return this.dataStore.getEntitySet(entitySet.getName());
    }

    public Object readData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        return this.dataStore.getRecordByKey(entitySet.getName(), keys);
    }

    public Object readData(EdmFunctionImport function, Map<String, Object> parameters, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public Object readRelatedData(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public DataSource.BinaryData readBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public Object newDataObject(EdmEntitySet entitySet) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        return new HashMap();
    }

    public void writeBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData, DataSource.BinaryData binaryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public void deleteData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        Map<String, Object> record = this.dataStore.getRecordByKey(entitySet.getName(), keys);
        if (record == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        this.dataStore.remove(entitySet.getName(), record);
    }

    public void createData(EdmEntitySet entitySet, Object data) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        if (!(data instanceof Map)) {
            throw new ODataApplicationException("Inserted record is of invalid type " + data.getClass().getName(), Locale.getDefault());
        }
        this.dataStore.put(entitySet.getName(), (Map)data);
    }

    public void deleteRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public void writeRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public MockDataSource(EdmProvider edmProvider, MockDataStore dataStore) {
        this.edmProvider = edmProvider;
        this.dataStore = dataStore;
    }

    public MockDataStore getDataStore() {
        return this.dataStore;
    }
}

