/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.NonNull;
import ninja.abap.odatamock.server.MapValueAccess;
import ninja.abap.odatamock.server.MockDataSource;
import ninja.abap.odatamock.server.MockListsProcessor;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.core.edm.provider.EdmxProvider;
import org.apache.olingo.odata2.core.processor.ODataSingleProcessorService;

class MockServiceFactory
extends ODataServiceFactory {
    protected final String edmx;
    protected final Edm edm;
    protected final EdmxProvider edmProvider;
    protected final MockDataSource dataSource;
    protected final MapValueAccess valueAccess;
    protected final MockListsProcessor processor;

    MockServiceFactory(@NonNull InputStream edmx) throws ODataException, IOException {
        if (edmx == null) {
            throw new NullPointerException("edmx is marked non-null but is null");
        }
        this.edmx = IOUtils.toString((InputStream)edmx, (Charset)StandardCharsets.UTF_8);
        this.edm = EntityProvider.readMetadata((InputStream)IOUtils.toInputStream((String)this.edmx, (Charset)StandardCharsets.UTF_8), (boolean)true);
        this.edmProvider = new EdmxProvider().parse(IOUtils.toInputStream((String)this.edmx, (Charset)StandardCharsets.UTF_8), true);
        this.dataSource = new MockDataSource((EdmProvider)this.edmProvider);
        this.valueAccess = new MapValueAccess();
        this.processor = new MockListsProcessor(this.dataSource, this.valueAccess);
    }

    public ODataService createService(ODataContext ctx) throws ODataException {
        return new ODataSingleProcessorService((EdmProvider)this.edmProvider, (ODataSingleProcessor)this.processor);
    }

    public String getEdmx() {
        return this.edmx;
    }

    public Edm getEdm() {
        return this.edm;
    }

    public EdmxProvider getEdmProvider() {
        return this.edmProvider;
    }

    public MockDataSource getDataSource() {
        return this.dataSource;
    }
}

