/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.io.IOException;
import java.net.URI;
import javax.servlet.Servlet;
import lombok.NonNull;
import ninja.abap.odatamock.server.MockDataLoader;
import ninja.abap.odatamock.server.MockDataStore;
import ninja.abap.odatamock.server.MockServiceFactory;
import ninja.abap.odatamock.server.MockServlet;
import ninja.abap.odatamock.server.ODataMockServerBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ODataMockServer {
    protected Server server;
    protected URI uri;
    protected MockDataStore dataStore;
    protected final ODataMockServerBuilder options;
    protected MockServiceFactory serviceFactory;
    protected MockServlet servlet;

    ODataMockServer(@NonNull ODataMockServerBuilder options) throws ODataException, IOException, Exception {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
        this.serviceFactory = new MockServiceFactory(options.edmx());
        this.servlet = new MockServlet(this.serviceFactory);
        this.dataStore = this.serviceFactory.getDataSource().getDataStore();
        if (options.localDataPath() != null) {
            MockDataLoader loader = new MockDataLoader(this.serviceFactory.getEdm(), (EdmProvider)this.serviceFactory.getEdmProvider(), options.localDataPath(), this.serviceFactory.getDataSource().getDataStore());
            loader.load(options.generateMissing());
        }
        this.start();
    }

    public void start() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            return;
        }
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.options.portNumber());
        this.server.setConnectors(new Connector[]{connector});
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        ServletContextHandler newHandler = new ServletContextHandler(1);
        newHandler.setContextPath("/");
        String servletPath = StringUtils.removeEnd((String)this.options.rootPath(), (String)"/");
        newHandler.addServlet(servletHolder, servletPath + "/*");
        this.server.setHandler((Handler)newHandler);
        this.server.start();
        this.uri = new URI(StringUtils.appendIfMissing((String)(this.server.getURI().toString() + servletPath), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
        }
    }

    public Server getServer() {
        return this.server;
    }

    public URI getUri() {
        return this.uri;
    }

    public ODataMockServerBuilder getOptions() {
        return this.options;
    }

    public MockServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public MockServlet getServlet() {
        return this.servlet;
    }

    public MockDataStore getDataStore() {
        return this.dataStore;
    }
}

