/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import ninja.abap.odatamock.server.MockDataGenerator;
import ninja.abap.odatamock.server.MockDataStore;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.ODataException;

class MockDataLoader {
    protected final Edm edm;
    protected final EdmProvider edmProvider;
    protected final Path directory;
    protected final MockDataStore dataStore;

    MockDataLoader(@NonNull Edm edm, @NonNull EdmProvider edmProvider, @NonNull String path, @NonNull MockDataStore dataStore) throws ODataException {
        if (edm == null) {
            throw new NullPointerException("edm is marked non-null but is null");
        }
        if (edmProvider == null) {
            throw new NullPointerException("edmProvider is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (dataStore == null) {
            throw new NullPointerException("dataStore is marked non-null but is null");
        }
        this.edm = edm;
        this.edmProvider = edmProvider;
        this.directory = Paths.get(path, new String[0]);
        this.dataStore = dataStore;
    }

    public void load(boolean generateMissing) throws ODataException {
        MockDataGenerator generator = new MockDataGenerator(this.edm, this.edmProvider);
        for (EdmEntitySet entitySet : this.edm.getEntitySets()) {
            try {
                this.dataStore.putAll(entitySet.getName(), this.loadDataFromFile(entitySet.getName()));
            }
            catch (FileNotFoundException e) {
                if (!generateMissing) continue;
                this.dataStore.putAll(entitySet.getName(), generator.generate(entitySet.getName()));
            }
            catch (Exception e) {
                String error = String.format("Error loading data for %s from %s: %s", entitySet.getName(), this.directory, e.getMessage());
                throw new ODataException(error, (Throwable)e);
            }
        }
    }

    protected List<Map<String, Object>> loadDataFromFile(String name) throws IOException, EntityProviderException, EdmException {
        File file = this.directory.resolve(name + ".json").toFile();
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        ByteArrayInputStream json = new ByteArrayInputStream(Files.readAllBytes(file.toPath()));
        ODataFeed feed = EntityProvider.readFeed((String)"application/json", (EdmEntitySet)this.edm.getDefaultEntityContainer().getEntitySet(name), (InputStream)json, (EntityProviderReadProperties)EntityProviderReadProperties.init().build());
        return feed.getEntries().stream().map(e -> e.getProperties()).collect(Collectors.toList());
    }
}

