/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ninja.abap.odatamock.event.FunctionImportHandler;
import ninja.abap.odatamock.server.MockDataStore;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataSource;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;

public class MockDataSource
implements DataSource {
    protected final EdmProvider edmProvider;
    protected final MockDataStore dataStore;
    protected final Map<String, FunctionImportHandler> functionImportHandlers = new HashMap<String, FunctionImportHandler>();

    public List<?> readData(EdmEntitySet entitySet) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        return this.dataStore.getEntitySet(entitySet.getName());
    }

    public Object readData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        return this.dataStore.getRecordByKey(entitySet.getName(), keys);
    }

    public Object readData(EdmFunctionImport function, Map<String, Object> parameters, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        FunctionImportHandler handler = this.functionImportHandlers.get(function.getName());
        if (handler != null) {
            return handler.handle(function, parameters, keys);
        }
        throw new ODataNotImplementedException();
    }

    public Object readRelatedData(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        if (targetKeys != null && !targetKeys.isEmpty()) {
            return this.dataStore.getRecordByKey(targetEntitySet.getName(), targetKeys);
        }
        Map sourceEntry = (Map)sourceData;
        String assocName = this.findNavigationPropertyName(sourceEntitySet, targetEntitySet);
        List association = (List)sourceEntry.get(assocName);
        if (association == null) {
            return Collections.emptyList();
        }
        return association;
    }

    public DataSource.BinaryData readBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public Object newDataObject(EdmEntitySet entitySet) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        return new HashMap();
    }

    public void writeBinaryData(EdmEntitySet entitySet, Object mediaLinkEntryData, DataSource.BinaryData binaryData) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public void deleteData(EdmEntitySet entitySet, Map<String, Object> keys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        Map<String, Object> record = this.dataStore.getRecordByKey(entitySet.getName(), keys);
        if (record == null) {
            throw new ODataNotFoundException(ODataNotFoundException.ENTITY);
        }
        this.dataStore.remove(entitySet.getName(), record);
    }

    public void createData(EdmEntitySet entitySet, Object data) throws ODataNotImplementedException, EdmException, ODataApplicationException {
        if (!(data instanceof Map)) {
            throw new ODataApplicationException("Inserted record is of invalid type " + data.getClass().getName(), Locale.getDefault());
        }
        this.dataStore.insert(entitySet.getName(), (Map)data);
    }

    public void deleteRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        throw new ODataNotImplementedException();
    }

    public void writeRelation(EdmEntitySet sourceEntitySet, Object sourceData, EdmEntitySet targetEntitySet, Map<String, Object> targetKeys) throws ODataNotImplementedException, ODataNotFoundException, EdmException, ODataApplicationException {
        Map sourceEntry = (Map)sourceData;
        String assocName = this.findNavigationPropertyName(sourceEntitySet, targetEntitySet);
        ArrayList<Map<String, Object>> association = (ArrayList<Map<String, Object>>)sourceEntry.get(assocName);
        if (association == null) {
            association = new ArrayList<Map<String, Object>>();
            sourceEntry.put(assocName, association);
        }
        association.add(targetKeys);
        this.dataStore.put(sourceEntitySet.getName(), sourceEntry);
    }

    protected String findNavigationPropertyName(EdmEntitySet sourceEntitySet, EdmEntitySet targetEntitySet) throws EdmException {
        EdmEntityType sourceEntityType = sourceEntitySet.getEntityType();
        EdmEntityType targetEntityType = targetEntitySet.getEntityType();
        for (String propertyName : sourceEntityType.getNavigationPropertyNames()) {
            EdmNavigationProperty navProp = (EdmNavigationProperty)sourceEntityType.getProperty(propertyName);
            EdmEntityType navET = navProp.getRelationship().getEnd2().getEntityType();
            if (navET != targetEntityType) continue;
            return navProp.getName();
        }
        throw new EdmException(EdmException.NAVIGATIONPROPERTYNOTFOUND);
    }

    public MockDataSource(EdmProvider edmProvider, MockDataStore dataStore) {
        this.edmProvider = edmProvider;
        this.dataStore = dataStore;
    }

    public Map<String, FunctionImportHandler> getFunctionImportHandlers() {
        return this.functionImportHandlers;
    }
}

