/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.PropertyRef;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;

public class MockDataStore {
    protected final EdmProvider edmProvider;
    protected final Map<String, LinkedHashMap<Map<String, Object>, Map<String, Object>>> data = new HashMap<String, LinkedHashMap<Map<String, Object>, Map<String, Object>>>();
    protected Map<String, EntityType> entityTypes = new HashMap<String, EntityType>();

    MockDataStore(@NonNull EdmProvider edmProvider) throws ODataException {
        if (edmProvider == null) {
            throw new NullPointerException("edmProvider is marked non-null but is null");
        }
        this.edmProvider = edmProvider;
        for (Schema edmSchema : edmProvider.getSchemas()) {
            for (EntityContainer edmContainer : edmSchema.getEntityContainers()) {
                for (EntitySet edmES : edmContainer.getEntitySets()) {
                    this.data.put(edmES.getName(), new LinkedHashMap());
                    EntityType edmET = edmProvider.getEntityType(edmES.getEntityType());
                    this.entityTypes.put(edmES.getName(), edmET);
                }
            }
        }
    }

    public List<Map<String, Object>> getEntitySet(String entitySet) throws ODataApplicationException {
        if (!this.data.containsKey(entitySet)) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        return this.data.get(entitySet).values().stream().collect(Collectors.toList());
    }

    public void insert(String entitySet, Map<String, Object> record) throws ODataApplicationException {
        LinkedHashMap<Map<String, Object>, Map<String, Object>> esData = this.data.get(entitySet);
        if (esData == null) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        Map<String, Object> key = this.getRecordKey(entitySet, record);
        if (esData.containsKey(key)) {
            throw new ODataApplicationException(String.format("Cannot insert duplicate record key in %s", entitySet), Locale.getDefault());
        }
        esData.put(key, record);
    }

    public void put(String entitySet, Map<String, Object> record) throws ODataApplicationException {
        LinkedHashMap<Map<String, Object>, Map<String, Object>> esData = this.data.get(entitySet);
        if (esData == null) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        Map<String, Object> key = this.getRecordKey(entitySet, record);
        esData.put(key, record);
    }

    public void putAll(String entitySet, Iterable<Map<String, Object>> records) throws ODataApplicationException {
        LinkedHashMap<Map<String, Object>, Map<String, Object>> esData = this.data.get(entitySet);
        if (esData == null) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        for (Map<String, Object> record : records) {
            Map<String, Object> key = this.getRecordKey(entitySet, record);
            esData.put(key, record);
        }
    }

    public Map<String, Object> remove(String entitySet, Map<String, Object> key) throws ODataApplicationException {
        LinkedHashMap<Map<String, Object>, Map<String, Object>> esData = this.data.get(entitySet);
        if (esData == null) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        return (Map)esData.remove(key);
    }

    public Map<String, Object> getRecordByKey(String entitySet, Map<String, Object> key) throws ODataApplicationException {
        LinkedHashMap<Map<String, Object>, Map<String, Object>> esData = this.data.get(entitySet);
        if (esData == null) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        return esData.get(key);
    }

    public void truncate(String entitySet) throws ODataApplicationException {
        LinkedHashMap<Map<String, Object>, Map<String, Object>> esData = this.data.get(entitySet);
        if (esData == null) {
            throw new ODataApplicationException(String.format("Entity Set %s not found", entitySet), Locale.getDefault());
        }
        esData.clear();
    }

    public void clear() {
        this.data.keySet().parallelStream().forEach(name -> this.data.get(name).clear());
    }

    protected Map<String, Object> getRecordKey(String entitySet, Map<String, Object> record) throws ODataApplicationException {
        HashMap<String, Object> keyFields = new HashMap<String, Object>();
        EntityType entityType = this.entityTypes.get(entitySet);
        for (PropertyRef keyProp : entityType.getKey().getKeys()) {
            String propName = keyProp.getName();
            keyFields.put(propName, record.get(propName));
        }
        return keyFields;
    }

    public Map<String, LinkedHashMap<Map<String, Object>, Map<String, Object>>> getData() {
        return this.data;
    }
}

