/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.io.IOException;
import lombok.NonNull;
import ninja.abap.odatamock.server.MapValueAccess;
import ninja.abap.odatamock.server.MockListsProcessor;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataSource;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.core.edm.provider.EdmxProvider;
import org.apache.olingo.odata2.core.processor.ODataSingleProcessorService;

class MockServiceFactory
extends ODataServiceFactory {
    protected final EdmxProvider edmProvider;
    protected final DataSource dataSource;
    protected final MapValueAccess valueAccess;
    protected final MockListsProcessor processor;

    MockServiceFactory(@NonNull EdmxProvider edmProvider, DataSource dataSource) throws ODataException, IOException {
        if (edmProvider == null) {
            throw new NullPointerException("edmProvider is marked non-null but is null");
        }
        this.edmProvider = edmProvider;
        this.dataSource = dataSource;
        this.valueAccess = new MapValueAccess();
        this.processor = new MockListsProcessor(dataSource, this.valueAccess);
    }

    public ODataService createService(ODataContext ctx) throws ODataException {
        return new ODataSingleProcessorService((EdmProvider)this.edmProvider, (ODataSingleProcessor)this.processor);
    }
}

