/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import lombok.NonNull;
import ninja.abap.odatamock.event.FunctionImportHandler;
import ninja.abap.odatamock.server.MockDataLoader;
import ninja.abap.odatamock.server.MockDataSource;
import ninja.abap.odatamock.server.MockDataStore;
import ninja.abap.odatamock.server.MockServiceFactory;
import ninja.abap.odatamock.server.MockServlet;
import ninja.abap.odatamock.server.ODataMockServerBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.annotation.processor.core.datasource.DataSource;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.edm.provider.EdmxProvider;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ODataMockServer {
    protected Server server;
    protected URI uri;
    protected MockDataStore dataStore;
    protected final String edmx;
    protected final Edm edm;
    protected final EdmxProvider edmProvider;
    protected final ODataMockServerBuilder options;
    protected DataSource dataSource;
    protected MockServiceFactory serviceFactory;
    protected MockServlet servlet;

    ODataMockServer(@NonNull ODataMockServerBuilder options) throws ODataException, IOException, Exception {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
        this.edmx = IOUtils.toString((InputStream)options.edmx(), (Charset)StandardCharsets.UTF_8);
        this.edm = EntityProvider.readMetadata((InputStream)IOUtils.toInputStream((String)this.edmx, (Charset)StandardCharsets.UTF_8), (boolean)true);
        this.edmProvider = new EdmxProvider().parse(IOUtils.toInputStream((String)this.edmx, (Charset)StandardCharsets.UTF_8), true);
        this.dataStore = new MockDataStore((EdmProvider)this.edmProvider);
        this.dataSource = this.createDataSource();
        this.serviceFactory = new MockServiceFactory(this.edmProvider, this.dataSource);
        this.servlet = new MockServlet(this.serviceFactory);
        if (options.localDataPath() != null) {
            MockDataLoader loader = new MockDataLoader(this.edm, (EdmProvider)this.edmProvider, options.localDataPath(), this.dataStore);
            loader.load(options.generateMissing());
        }
        this.start();
    }

    public void start() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            return;
        }
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.options.portNumber());
        this.server.setConnectors(new Connector[]{connector});
        ServletHolder servletHolder = new ServletHolder((Servlet)this.servlet);
        ServletContextHandler newHandler = new ServletContextHandler(1);
        newHandler.setContextPath("/");
        String servletPath = StringUtils.removeEnd((String)this.options.rootPath(), (String)"/");
        newHandler.addServlet(servletHolder, servletPath + "/*");
        this.server.setHandler((Handler)newHandler);
        this.server.start();
        this.uri = new URI(StringUtils.appendIfMissing((String)(this.server.getURI().toString() + servletPath), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
        }
    }

    public ODataMockServer onFunctionImport(String functionName, FunctionImportHandler handler) {
        if (this.dataSource instanceof MockDataSource) {
            MockDataSource mds = (MockDataSource)this.dataSource;
            mds.getFunctionImportHandlers().put(functionName, handler);
        }
        return this;
    }

    public ODataMockServer clearHandlers() {
        if (this.dataSource instanceof MockDataSource) {
            MockDataSource mds = (MockDataSource)this.dataSource;
            mds.getFunctionImportHandlers().clear();
        }
        return this;
    }

    protected DataSource createDataSource() throws ODataException {
        return new MockDataSource((EdmProvider)this.edmProvider, this.dataStore);
    }

    public Server getServer() {
        return this.server;
    }

    public URI getUri() {
        return this.uri;
    }

    public ODataMockServerBuilder getOptions() {
        return this.options;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public MockServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public MockServlet getServlet() {
        return this.servlet;
    }

    public MockDataStore getDataStore() {
        return this.dataStore;
    }

    public String getEdmx() {
        return this.edmx;
    }

    public Edm getEdm() {
        return this.edm;
    }

    public EdmxProvider getEdmProvider() {
        return this.edmProvider;
    }
}

