/*
 * Decompiled with CFR 0.152.
 */
package ninja.abap.odatamock.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import lombok.NonNull;
import ninja.abap.odatamock.server.ODataMockServer;

public class ODataMockServerBuilder {
    protected InputStream edmx;
    protected int portNumber = 0;
    protected String rootPath = "/";
    protected String localDataPath = null;
    protected boolean generateMissing = false;

    public ODataMockServerBuilder edmxFromFile(@NonNull String edmxPath) throws IOException {
        if (edmxPath == null) {
            throw new NullPointerException("edmxPath is marked non-null but is null");
        }
        this.edmx = Files.newInputStream(Paths.get(edmxPath, new String[0]), StandardOpenOption.READ);
        return this;
    }

    public ODataMockServer build() throws Exception {
        return new ODataMockServer(this);
    }

    public InputStream edmx() {
        return this.edmx;
    }

    public int portNumber() {
        return this.portNumber;
    }

    public String rootPath() {
        return this.rootPath;
    }

    public String localDataPath() {
        return this.localDataPath;
    }

    public boolean generateMissing() {
        return this.generateMissing;
    }

    public ODataMockServerBuilder edmx(InputStream edmx) {
        this.edmx = edmx;
        return this;
    }

    public ODataMockServerBuilder portNumber(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public ODataMockServerBuilder rootPath(String rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public ODataMockServerBuilder localDataPath(String localDataPath) {
        this.localDataPath = localDataPath;
        return this;
    }

    public ODataMockServerBuilder generateMissing(boolean generateMissing) {
        this.generateMissing = generateMissing;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataMockServerBuilder)) {
            return false;
        }
        ODataMockServerBuilder other = (ODataMockServerBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InputStream this$edmx = this.edmx();
        InputStream other$edmx = other.edmx();
        if (this$edmx == null ? other$edmx != null : !this$edmx.equals(other$edmx)) {
            return false;
        }
        if (this.portNumber() != other.portNumber()) {
            return false;
        }
        String this$rootPath = this.rootPath();
        String other$rootPath = other.rootPath();
        if (this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath)) {
            return false;
        }
        String this$localDataPath = this.localDataPath();
        String other$localDataPath = other.localDataPath();
        if (this$localDataPath == null ? other$localDataPath != null : !this$localDataPath.equals(other$localDataPath)) {
            return false;
        }
        return this.generateMissing() == other.generateMissing();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ODataMockServerBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputStream $edmx = this.edmx();
        result = result * 59 + ($edmx == null ? 43 : $edmx.hashCode());
        result = result * 59 + this.portNumber();
        String $rootPath = this.rootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        String $localDataPath = this.localDataPath();
        result = result * 59 + ($localDataPath == null ? 43 : $localDataPath.hashCode());
        result = result * 59 + (this.generateMissing() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ODataMockServerBuilder(edmx=" + this.edmx() + ", portNumber=" + this.portNumber() + ", rootPath=" + this.rootPath() + ", localDataPath=" + this.localDataPath() + ", generateMissing=" + this.generateMissing() + ")";
    }
}

