/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.executor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class Docker {
    private static final String REGISTRY_SEPARATOR = "/";
    private static final String TAG_SEPARATOR = ":";
    private static final String ALL_WHITESPACE = "\\s+";
    private static final String SINGLE_SPACE = " ";

    public static String getImage(String registry, String name, String tag) {
        if (name == null || "".equals(name.trim())) {
            return name;
        }
        StringBuilder image = new StringBuilder();
        if (registry != null && !"".equals(registry.trim())) {
            image.append(registry);
            if (!registry.endsWith(REGISTRY_SEPARATOR)) {
                image.append(REGISTRY_SEPARATOR);
            }
        }
        image.append(name);
        if (tag != null && !"".equals(tag.trim())) {
            image.append(TAG_SEPARATOR);
            image.append(tag);
        }
        return image.toString();
    }

    public static List<String> splitOptions(String options) {
        if (options != null && !"".equals(options.trim())) {
            String normalized = options.replaceAll(ALL_WHITESPACE, SINGLE_SPACE).trim();
            return Arrays.asList(normalized.split(SINGLE_SPACE));
        }
        return Collections.emptyList();
    }
}

