/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.executor;

import java.util.ArrayList;
import java.util.List;
import nl.futureedge.maven.docker.exception.DockerExecutionException;
import nl.futureedge.maven.docker.executor.DockerExecutor;

public final class DockerCommands {
    private DockerCommands() {
    }

    public static List<String> listContainers(DockerExecutor executor, String filter) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("ps");
        arguments.add("-a");
        arguments.add("-q");
        if (filter != null && !"".equals(filter)) {
            arguments.add("--filter");
            arguments.add(filter);
        }
        arguments.add("--format");
        arguments.add("{{.Names}}");
        return executor.execute(arguments, false, true);
    }

    public static void startContainer(DockerExecutor executor, String container) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("start");
        arguments.add(container);
        executor.execute(arguments, false, false);
    }

    public static void stopContainer(DockerExecutor executor, String container) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("stop");
        arguments.add(container);
        executor.execute(arguments, false, false);
    }

    public static void removeContainer(DockerExecutor executor, String container) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("rm");
        arguments.add("-vf");
        arguments.add(container);
        executor.execute(arguments, false, false);
    }

    public static List<String> listImages(DockerExecutor executor, String filter) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("images");
        arguments.add("-q");
        if (filter != null && !"".equals(filter)) {
            arguments.add("--filter");
            arguments.add(filter);
        }
        return executor.execute(arguments, false, true);
    }

    public static void removeImage(DockerExecutor executor, String image) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("rmi");
        arguments.add("-f");
        arguments.add(image);
        executor.execute(arguments, false, false);
    }

    public static List<String> listServices(DockerExecutor executor, String filter) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("service");
        arguments.add("ls");
        arguments.add("-q");
        if (filter != null && !"".equals(filter)) {
            arguments.add("--filter");
            arguments.add(filter);
        }
        return executor.execute(arguments, false, true);
    }

    public static void removeService(DockerExecutor executor, String service) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("service");
        arguments.add("rm");
        arguments.add(service);
        executor.execute(arguments, false, false);
    }

    public static List<String> listVolumes(DockerExecutor executor, String filter) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("volume");
        arguments.add("ls");
        arguments.add("-q");
        if (filter != null && !"".equals(filter)) {
            arguments.add("--filter");
            arguments.add(filter);
        }
        return executor.execute(arguments, false, true);
    }

    public static void removeVolume(DockerExecutor executor, String volume) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("volume");
        arguments.add("rm");
        arguments.add(volume);
        executor.execute(arguments, false, false);
    }
}

