/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.executor;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import nl.futureedge.maven.docker.exception.DockerExecutionException;
import nl.futureedge.maven.docker.executor.Docker;

public final class DockerExecutor {
    private final Consumer<String> debugLogger;
    private final Consumer<String> infoLogger;
    private final BiConsumer<String, Exception> warnLogger;
    private final List<String> baseCommand;

    public DockerExecutor(Consumer<String> debugLogger, Consumer<String> infoLogger, BiConsumer<String, Exception> warnLogger, String dockerOptions) {
        this.debugLogger = debugLogger;
        this.infoLogger = infoLogger;
        this.warnLogger = warnLogger;
        this.baseCommand = new ArrayList<String>();
        this.baseCommand.add("docker");
        this.baseCommand.addAll(Docker.splitOptions(dockerOptions));
    }

    public void execute(List<String> arguments) throws DockerExecutionException {
        this.execute(arguments, true, false);
    }

    public List<String> execute(List<String> arguments, boolean logOut, boolean returnOut) throws DockerExecutionException {
        Process process;
        ArrayList<String> command = new ArrayList<String>(this.baseCommand);
        command.addAll(arguments);
        this.debugLogger.accept(String.format("Docker command: %s", command));
        ProcessBuilder pb = new ProcessBuilder(command);
        try {
            process = pb.start();
        }
        catch (IOException e) {
            throw new DockerExecutionException("Could not execute Docker command", e);
        }
        try {
            return this.executeProcess(process, logOut, returnOut);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> executeProcess(Process process, boolean logOut, boolean returnOut) throws DockerExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final class StdErrReader
    implements Runnable {
        private final BufferedReader procesStdErr;

        public StdErrReader(BufferedReader procesStdErr) {
            this.procesStdErr = procesStdErr;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.procesStdErr.readLine()) != null) {
                    DockerExecutor.this.warnLogger.accept(line, null);
                }
            }
            catch (IOException e) {
                DockerExecutor.this.warnLogger.accept("Unexpected exception during read of StdErr", e);
            }
        }
    }

    private final class StdOutReader
    implements Runnable {
        private final BufferedReader procesStdOut;
        private final boolean logOut;
        private final List<String> output;

        public StdOutReader(BufferedReader procesStdOut, boolean logOut, List<String> output) {
            this.procesStdOut = procesStdOut;
            this.logOut = logOut;
            this.output = output;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.procesStdOut.readLine()) != null) {
                    if (this.logOut) {
                        DockerExecutor.this.infoLogger.accept(line);
                    } else {
                        DockerExecutor.this.debugLogger.accept(line);
                    }
                    if (this.output == null) continue;
                    this.output.add(line);
                }
            }
            catch (IOException e) {
                DockerExecutor.this.warnLogger.accept("Unexpected exception during read of StdOut", e);
            }
        }
    }
}

