/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.ArrayList;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.Docker;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.CreateNetworkSettings;
import nl.futureedge.maven.docker.support.DockerExecutable;

public final class CreateNetworkExecutable
extends DockerExecutable {
    private final String networkOptions;
    private final String networkName;

    public CreateNetworkExecutable(CreateNetworkSettings settings) {
        super(settings);
        this.networkOptions = settings.getNetworkOptions();
        this.networkName = settings.getNetworkName();
    }

    @Override
    public void execute() throws DockerException {
        this.debug("Create network configuration: ");
        this.debug("- networkOptions: " + this.networkOptions);
        this.debug("- networkName: " + this.networkName);
        DockerExecutor executor = this.createDockerExecutor();
        this.doIgnoringFailure(() -> this.createNetwork(executor));
    }

    private void createNetwork(DockerExecutor executor) throws DockerException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("network");
        arguments.add("create");
        arguments.addAll(Docker.splitOptions(this.networkOptions));
        arguments.add(this.networkName);
        executor.execute(arguments);
    }
}

