/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.exception.DockerExecutionException;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerSettings;

public abstract class DockerExecutable {
    private final Consumer<String> debugLogger;
    private final Consumer<String> infoLogger;
    private final BiConsumer<String, Exception> warnLogger;
    private final String dockerOptions;
    private final boolean ignoreFailures;

    protected DockerExecutable(DockerSettings settings) {
        this.debugLogger = settings.getDebugLogger();
        this.infoLogger = settings.getInfoLogger();
        this.warnLogger = settings.getWarnLogger();
        this.dockerOptions = settings.getDockerOptions();
        this.ignoreFailures = settings.isIgnoreFailures();
    }

    protected final void debug(String message) {
        this.debugLogger.accept(message);
    }

    protected final void info(String message) {
        this.infoLogger.accept(message);
    }

    protected final void warn(String message) {
        this.warnLogger.accept(message, null);
    }

    protected final void warn(String message, Exception exception) {
        this.warnLogger.accept(message, exception);
    }

    protected final DockerExecutor createDockerExecutor() {
        return new DockerExecutor(this.debugLogger, this.infoLogger, this.warnLogger, this.dockerOptions);
    }

    protected final <E extends Exception> void doIgnoringFailure(Execution<E> execution) throws E, DockerException {
        block2: {
            try {
                execution.execute();
            }
            catch (DockerExecutionException e) {
                if (this.ignoreFailures) break block2;
                throw e;
            }
        }
    }

    protected final <T, E extends Exception> T doIgnoringFailure(Command<T, E> command) throws E, DockerException {
        try {
            return command.execute();
        }
        catch (DockerExecutionException e) {
            if (!this.ignoreFailures) {
                throw e;
            }
            return null;
        }
    }

    public abstract void execute() throws DockerException;

    @FunctionalInterface
    protected static interface Execution<E extends Exception> {
        public void execute() throws DockerException, E;
    }

    @FunctionalInterface
    protected static interface Command<T, E extends Exception> {
        public T execute() throws DockerException, E;
    }
}

