/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface DockerSettings {
    public Consumer<String> getDebugLogger();

    public Consumer<String> getInfoLogger();

    public BiConsumer<String, Exception> getWarnLogger();

    public String getDockerOptions();

    public boolean isIgnoreFailures();

    public static Builder builder() {
        return new Builder();
    }

    public static void defaultDebug(String message) {
    }

    public static void defaultInfo(String message) {
        System.out.println(message);
    }

    public static void defaultWarn(String message, Exception exception) {
        System.err.println(message);
        if (exception != null) {
            exception.printStackTrace(System.err);
        }
    }

    public static class DockerSettingsImpl
    implements DockerSettings {
        private final Consumer<String> debugLogger;
        private final Consumer<String> infoLogger;
        private final BiConsumer<String, Exception> warnLogger;
        private final String dockerOptions;
        private final boolean ignoreFailures;

        protected DockerSettingsImpl(Builder builder) {
            this.debugLogger = builder.debugLogger;
            this.infoLogger = builder.infoLogger;
            this.warnLogger = builder.warnLogger;
            this.dockerOptions = builder.dockerOptions;
            this.ignoreFailures = builder.ignoreFailures;
        }

        @Override
        public Consumer<String> getDebugLogger() {
            return this.debugLogger;
        }

        @Override
        public Consumer<String> getInfoLogger() {
            return this.infoLogger;
        }

        @Override
        public BiConsumer<String, Exception> getWarnLogger() {
            return this.warnLogger;
        }

        @Override
        public String getDockerOptions() {
            return this.dockerOptions;
        }

        @Override
        public boolean isIgnoreFailures() {
            return this.ignoreFailures;
        }
    }

    public static class Builder<T extends Builder> {
        private T builder;
        private Consumer<String> debugLogger = DockerSettings::defaultDebug;
        private Consumer<String> infoLogger = DockerSettings::defaultInfo;
        private BiConsumer<String, Exception> warnLogger = DockerSettings::defaultWarn;
        private String dockerOptions;
        private boolean ignoreFailures = false;

        protected final void setBuilder(T builder) {
            this.builder = builder;
        }

        public DockerSettings build() {
            return new DockerSettingsImpl(this);
        }

        public final T setDebugLogger(Consumer<String> debugLogger) {
            this.debugLogger = debugLogger;
            return this.builder;
        }

        public final T setInfoLogger(Consumer<String> infoLogger) {
            this.infoLogger = infoLogger;
            return this.builder;
        }

        public final T setWarnLogger(BiConsumer<String, Exception> warnLogger) {
            this.warnLogger = warnLogger;
            return this.builder;
        }

        public final T setDockerOptions(String dockerOptions) {
            this.dockerOptions = dockerOptions;
            return this.builder;
        }

        public final T setIgnoreFailures(boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this.builder;
        }
    }
}

