/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.InspectContainerSettings;

public final class InspectContainerExecutable
extends DockerExecutable {
    private final Properties projectProperties;
    private final String containerId;
    private final String containerNameProperty;
    private final String hostnameProperty;
    private final Properties portProperties;

    public InspectContainerExecutable(InspectContainerSettings settings) {
        super(settings);
        this.projectProperties = settings.getProjectProperties();
        this.containerId = settings.getContainerId();
        this.containerNameProperty = settings.getContainerNameProperty();
        this.hostnameProperty = settings.getHostnameProperty();
        this.portProperties = settings.getPortProperties();
    }

    @Override
    public void execute() throws DockerException {
        this.info("Inspect container configuration: ");
        this.debug("- projectProperties: " + this.projectProperties);
        this.info("- containerId: " + this.containerId);
        this.info("- containerNameProperty: " + this.containerNameProperty);
        this.info("- hostnameProperty: " + this.hostnameProperty);
        this.info("- portProperties: " + this.portProperties);
        DockerExecutor executor = this.createDockerExecutor();
        String containerInfoJson = this.doIgnoringFailure(() -> this.inspectContainer(executor, this.containerId));
        JsonParser parser = new JsonParser();
        JsonArray containerInfos = parser.parse(containerInfoJson).getAsJsonArray();
        JsonObject containerInfo = containerInfos.get(0).getAsJsonObject();
        this.handleContainerName(containerInfo);
        this.handleHostname(containerInfo);
        this.handlePorts(containerInfo);
    }

    private void handleContainerName(JsonObject containerInfo) {
        if (this.containerNameProperty == null || "".equals(this.containerNameProperty.trim())) {
            this.debug("Skipping container name as no property is set");
            return;
        }
        JsonPrimitive name = containerInfo.getAsJsonPrimitive("Name");
        if (name == null) {
            this.warn("Name: Name primitive not found");
            return;
        }
        String containerName = name.getAsString();
        if (containerName.startsWith("/")) {
            containerName = containerName.substring(1);
        }
        this.info("Name: " + containerName);
        this.projectProperties.setProperty(this.containerNameProperty, containerName);
    }

    private void handleHostname(JsonObject containerInfo) {
        if (this.hostnameProperty == null || "".equals(this.hostnameProperty.trim())) {
            this.debug("Skipping hostname as no property is set");
            return;
        }
        JsonObject config = containerInfo.getAsJsonObject("Config");
        if (config == null) {
            this.warn("Hostname: Config object not found");
            return;
        }
        JsonPrimitive hostname = config.getAsJsonPrimitive("Hostname");
        if (hostname == null) {
            this.warn("Hostname: Hostname primitive not found");
            return;
        }
        this.info("Hostname: " + hostname.getAsString());
        this.projectProperties.setProperty(this.hostnameProperty, hostname.getAsString());
    }

    private void handlePorts(JsonObject containerInfo) {
        if (this.portProperties == null || this.portProperties.isEmpty()) {
            this.debug("Skipping port as no property is set");
            return;
        }
        JsonObject networkSettings = containerInfo.getAsJsonObject("NetworkSettings");
        if (networkSettings == null) {
            this.warn("Ports: NetworkSettings object not found");
            return;
        }
        JsonObject ports = networkSettings.getAsJsonObject("Ports");
        if (ports == null) {
            this.warn("Ports: Ports object not found");
            return;
        }
        for (String portPropertyKey : this.portProperties.stringPropertyNames()) {
            JsonArray mappings = ports.getAsJsonArray(portPropertyKey);
            if (mappings == null || mappings.size() == 0) {
                this.warn("Port " + portPropertyKey + ": not mapped");
                continue;
            }
            if (mappings.size() > 1) {
                this.warn("Port " + portPropertyKey + " is mapped multiple times; an undetermined mapping wil be returned");
            }
            JsonObject mapping = mappings.get(0).getAsJsonObject();
            JsonPrimitive port = mapping.getAsJsonPrimitive("HostPort");
            this.info("Port " + portPropertyKey + ": " + port.getAsString());
            this.projectProperties.setProperty(this.portProperties.getProperty(portPropertyKey), port.getAsString());
        }
    }

    private String inspectContainer(DockerExecutor executor, String containerId) throws DockerException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("inspect");
        arguments.add("--type");
        arguments.add("container");
        arguments.add(containerId);
        List<String> result = executor.execute(arguments, false, true);
        return result.stream().collect(Collectors.joining());
    }
}

