/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.List;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.DockerCommands;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.RemoveImagesSettings;

public final class RemoveImagesExecutable
extends DockerExecutable {
    private final String filter;

    public RemoveImagesExecutable(RemoveImagesSettings settings) {
        super(settings);
        this.filter = settings.getFilter();
    }

    @Override
    public void execute() throws DockerException {
        this.debug("Remove images configuration: ");
        this.debug("- filter: " + this.filter);
        DockerExecutor executor = this.createDockerExecutor();
        List images = this.doIgnoringFailure(() -> DockerCommands.listImages(executor, this.filter));
        if (images != null) {
            for (String image : images) {
                if ("".equals(image.trim())) continue;
                this.info("Remove image: " + image);
                this.doIgnoringFailure(() -> DockerCommands.removeImage(executor, image));
            }
        }
    }
}

