/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.ArrayList;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.RemoveNetworkSettings;

public final class RemoveNetworkExecutable
extends DockerExecutable {
    private final String networkName;

    public RemoveNetworkExecutable(RemoveNetworkSettings settings) {
        super(settings);
        this.networkName = settings.getNetworkName();
    }

    @Override
    public void execute() throws DockerException {
        this.debug("Remove network configuration: ");
        this.debug("- networkName: " + this.networkName);
        DockerExecutor executor = this.createDockerExecutor();
        this.doIgnoringFailure(() -> this.createNetwork(executor));
    }

    private void createNetwork(DockerExecutor executor) throws DockerException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("network");
        arguments.add("rm");
        arguments.add(this.networkName);
        executor.execute(arguments, false, false);
    }
}

