/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.List;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.DockerCommands;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.RemoveServicesSettings;

public final class RemoveServicesExecutable
extends DockerExecutable {
    private final String filter;

    public RemoveServicesExecutable(RemoveServicesSettings settings) {
        super(settings);
        this.filter = settings.getFilter();
    }

    @Override
    public void execute() throws DockerException {
        this.debug("Remove services configuration: ");
        this.debug("- filter: " + this.filter);
        DockerExecutor executor = this.createDockerExecutor();
        List services = this.doIgnoringFailure(() -> DockerCommands.listServices(executor, this.filter));
        if (services != null) {
            for (String service : services) {
                if ("".equals(service.trim())) continue;
                this.info("Remove service: " + service);
                this.doIgnoringFailure(() -> DockerCommands.removeService(executor, service));
            }
        }
    }
}

