/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.List;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.DockerCommands;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.RemoveVolumesSettings;

public final class RemoveVolumesExecutable
extends DockerExecutable {
    private final String filter;

    public RemoveVolumesExecutable(RemoveVolumesSettings settings) {
        super(settings);
        this.filter = settings.getFilter();
    }

    @Override
    public void execute() throws DockerException {
        this.debug("Remove volumes configuration: ");
        this.debug("- filter: " + this.filter);
        DockerExecutor executor = this.createDockerExecutor();
        List volumes = this.doIgnoringFailure(() -> DockerCommands.listVolumes(executor, this.filter));
        if (volumes != null) {
            for (String volume : volumes) {
                if ("".equals(volume.trim())) continue;
                this.info("Remove volume: " + volume);
                this.doIgnoringFailure(() -> DockerCommands.removeVolume(executor, volume));
            }
        }
    }
}

