/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import nl.futureedge.maven.docker.configuration.Configuration;
import nl.futureedge.maven.docker.configuration.ConfigurationLoader;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.exception.DockerExecutionException;
import nl.futureedge.maven.docker.executor.Docker;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.DockerSettings;
import nl.futureedge.maven.docker.support.InspectContainerExecutable;
import nl.futureedge.maven.docker.support.InspectContainerSettings;
import nl.futureedge.maven.docker.support.RunConfigurationSettings;
import nl.futureedge.maven.docker.support.RunExecutable;
import nl.futureedge.maven.docker.support.RunSettings;
import org.apache.commons.text.StrSubstitutor;

public class RunConfigurationExecutable
extends DockerExecutable {
    private final RunConfigurationSettings settings;
    private Set<String> loaded;
    private Stack<String> stack;
    private final String configurationName;
    private final boolean skipDependencies;

    public RunConfigurationExecutable(RunConfigurationSettings settings) {
        super(settings);
        this.settings = settings;
        this.loaded = settings.getLoaded();
        this.stack = settings.getStack();
        this.configurationName = settings.getConfigurationName();
        this.skipDependencies = settings.isSkipDependencies();
    }

    @Override
    public void execute() throws DockerException {
        String finished;
        if (this.loaded.contains(this.configurationName)) {
            this.debug("Skipping previously loaded configuration: " + this.configurationName);
            return;
        }
        if (this.stack.contains(this.configurationName)) {
            throw new DockerExecutionException("Cyclic dependency detected; current stack: " + this.stack.stream().collect(Collectors.joining(" -> ")) + " -> " + this.configurationName);
        }
        this.stack.push(this.configurationName);
        this.debug("Loading configuration: " + this.configurationName);
        Configuration configuration = ConfigurationLoader.loadConfiguration(this.configurationName);
        if (this.skipDependencies) {
            this.debug("Skipping dependent configurations");
        } else if (configuration.getDependsOn() != null && !configuration.getDependsOn().isEmpty()) {
            for (String dependsOn : configuration.getDependsOn()) {
                this.debug("Dependent configuration: " + dependsOn);
                ConfiguredRunConfigurationSettings runConfigurationSettings = new ConfiguredRunConfigurationSettings(this.settings, this.stack, this.loaded, dependsOn);
                new RunConfigurationExecutable(runConfigurationSettings).execute();
            }
        }
        if (configuration.getImageName() != null && !"".equals(configuration.getImageName())) {
            this.info("Running configuration: " + this.configurationName);
            ConfiguredRunSettings runSettings = new ConfiguredRunSettings(this.settings, configuration);
            RunExecutable runExecutable = new RunExecutable(runSettings);
            runExecutable.execute();
            String containerId = runExecutable.getContainerId();
            ConfiguredInspectContainerSettings inspectContainerSettings = new ConfiguredInspectContainerSettings(this.settings, configuration, containerId);
            new InspectContainerExecutable(inspectContainerSettings).execute();
        }
        if (!this.configurationName.equals(finished = this.stack.pop())) {
            throw new DockerExecutionException("Stack corrupted; removed '" + finished + "' but expected '" + this.configurationName + "'");
        }
        this.loaded.add(this.configurationName);
    }

    private static class ConfiguredInspectContainerSettings
    extends ConfiguredDockerSettings
    implements InspectContainerSettings {
        private final RunConfigurationSettings settings;
        private final Configuration configuration;
        private final String containerId;

        ConfiguredInspectContainerSettings(RunConfigurationSettings settings, Configuration configuration, String containerId) {
            super(settings);
            this.settings = settings;
            this.configuration = configuration;
            this.containerId = containerId;
        }

        @Override
        public final Properties getProjectProperties() {
            return this.settings.getProjectProperties();
        }

        @Override
        public final String getContainerId() {
            return this.containerId;
        }

        @Override
        public final String getContainerNameProperty() {
            return this.configuration.getContainerNameProperty();
        }

        @Override
        public String getHostnameProperty() {
            return this.configuration.getHostnameProperty();
        }

        @Override
        public final Properties getPortProperties() {
            Properties result = new Properties();
            if (this.configuration.getPorts() != null) {
                for (Configuration.Port port : this.configuration.getPorts()) {
                    result.setProperty(port.getPort(), port.getProperty());
                }
            }
            return result;
        }
    }

    private static class ConfiguredRunSettings
    extends ConfiguredDockerSettings
    implements RunSettings {
        private final RunConfigurationSettings settings;
        private final Configuration configuration;

        ConfiguredRunSettings(RunConfigurationSettings settings, Configuration configuration) {
            super(settings);
            this.settings = settings;
            this.configuration = configuration;
        }

        @Override
        public final Properties getProjectProperties() {
            return this.settings.getProjectProperties();
        }

        private String replace(String value) {
            Properties valueProperties = this.settings.getProjectProperties();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            Enumeration<?> propNames = valueProperties.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = valueProperties.getProperty(propName);
                valueMap.put(propName, propValue);
            }
            StrSubstitutor substitutor = new StrSubstitutor(valueMap);
            substitutor.setValueDelimiter(':');
            return substitutor.replace(value);
        }

        @Override
        public final String getRunOptions() {
            StringBuilder runOptions = new StringBuilder();
            if (this.configuration.getRunOptions() != null) {
                runOptions.append(this.configuration.getRunOptions());
            }
            if (this.settings.getAdditionalRunOptions() != null) {
                if (runOptions.length() > 0) {
                    runOptions.append(' ');
                }
                runOptions.append(this.settings.getAdditionalRunOptions());
            }
            if (this.settings.getNetworkName() != null && !"".equals(this.settings.getNetworkName().trim())) {
                runOptions.append(" --network ").append(this.settings.getNetworkName());
            }
            if (this.configuration.getPorts() != null) {
                for (Configuration.Port port : this.configuration.getPorts()) {
                    runOptions.append(" -p ");
                    if (!this.settings.isRandomPorts() && port.getExternal() != null && !"".equals(port.getExternal().trim())) {
                        runOptions.append(port.getExternal()).append(":");
                    }
                    runOptions.append(port.getPort());
                }
            }
            return this.replace(runOptions.toString());
        }

        @Override
        public boolean isDaemon() {
            return this.configuration.isDaemon();
        }

        @Override
        public final String getImage() {
            String imageRegistry = this.replace(this.configuration.getImageRegistry());
            String imageName = this.replace(this.configuration.getImageName());
            String imageTag = this.replace(this.configuration.getImageTag());
            return Docker.getImage(imageRegistry, imageName, imageTag);
        }

        @Override
        public final String getCommand() {
            String command = this.settings.getCommand() != null && !"".equals(this.settings.getCommand().trim()) ? this.settings.getCommand() : this.configuration.getCommand();
            return this.replace(command);
        }

        @Override
        public final String getContainerIdProperty() {
            return this.configuration.getContainerIdProperty();
        }
    }

    private static class ConfiguredRunConfigurationSettings
    extends ConfiguredDockerSettings
    implements RunConfigurationSettings {
        private final RunConfigurationSettings settings;
        private final Stack<String> stack;
        private final Set<String> loaded;
        private final String configurationName;

        ConfiguredRunConfigurationSettings(RunConfigurationSettings settings, Stack<String> stack, Set<String> loaded, String configurationName) {
            super(settings);
            this.settings = settings;
            this.stack = stack;
            this.loaded = loaded;
            this.configurationName = configurationName;
        }

        @Override
        public Stack<String> getStack() {
            return this.stack;
        }

        @Override
        public Set<String> getLoaded() {
            return this.loaded;
        }

        @Override
        public Properties getProjectProperties() {
            return this.settings.getProjectProperties();
        }

        @Override
        public String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public String getAdditionalRunOptions() {
            return null;
        }

        @Override
        public String getCommand() {
            return null;
        }

        @Override
        public String getNetworkName() {
            return this.settings.getNetworkName();
        }

        @Override
        public boolean isRandomPorts() {
            return this.settings.isRandomPorts();
        }

        @Override
        public boolean isSkipDependencies() {
            return this.settings.isSkipDependencies();
        }
    }

    private static class ConfiguredDockerSettings
    implements DockerSettings {
        private final DockerSettings settings;

        ConfiguredDockerSettings(RunConfigurationSettings settings) {
            this.settings = settings;
        }

        @Override
        public final Consumer<String> getDebugLogger() {
            return this.settings.getDebugLogger();
        }

        @Override
        public final Consumer<String> getInfoLogger() {
            return this.settings.getInfoLogger();
        }

        @Override
        public final BiConsumer<String, Exception> getWarnLogger() {
            return this.settings.getWarnLogger();
        }

        @Override
        public final String getDockerOptions() {
            return this.settings.getDockerOptions();
        }

        @Override
        public final boolean isIgnoreFailures() {
            return this.settings.isIgnoreFailures();
        }
    }
}

