/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import nl.futureedge.maven.docker.support.DockerSettings;

public interface RunConfigurationSettings
extends DockerSettings {
    default public Stack<String> getStack() {
        return new Stack<String>();
    }

    default public Set<String> getLoaded() {
        return new HashSet<String>();
    }

    public Properties getProjectProperties();

    public String getConfigurationName();

    public String getAdditionalRunOptions();

    public String getCommand();

    public String getNetworkName();

    public boolean isRandomPorts();

    public boolean isSkipDependencies();

    public static Builder builder() {
        return new Builder();
    }

    public static final class RunConfigurationSettingsImpl
    extends DockerSettings.DockerSettingsImpl
    implements RunConfigurationSettings {
        private final Stack stack;
        private final Set<String> loaded;
        private final Properties projectProperties;
        private final String configurationName;
        private final String additionalRunOptions;
        private final String command;
        private final String networkName;
        private final boolean randomPorts;
        private final boolean skipDependencies;

        protected RunConfigurationSettingsImpl(Builder builder) {
            super(builder);
            this.stack = builder.stack;
            this.loaded = builder.loaded;
            this.projectProperties = builder.projectProperties;
            this.configurationName = builder.configurationName;
            this.additionalRunOptions = builder.additionalRunOptions;
            this.command = builder.command;
            this.networkName = builder.networkName;
            this.randomPorts = builder.randomPorts;
            this.skipDependencies = builder.skipDependencies;
        }

        public Stack getStack() {
            return this.stack;
        }

        @Override
        public Set<String> getLoaded() {
            return this.loaded;
        }

        @Override
        public Properties getProjectProperties() {
            return this.projectProperties;
        }

        @Override
        public String getConfigurationName() {
            return this.configurationName;
        }

        @Override
        public String getAdditionalRunOptions() {
            return this.additionalRunOptions;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public String getNetworkName() {
            return this.networkName;
        }

        @Override
        public boolean isRandomPorts() {
            return this.randomPorts;
        }

        @Override
        public boolean isSkipDependencies() {
            return this.skipDependencies;
        }
    }

    public static final class Builder
    extends DockerSettings.Builder<Builder> {
        private Stack stack = new Stack();
        private Set<String> loaded = new HashSet<String>();
        private Properties projectProperties = System.getProperties();
        private String configurationName;
        private String additionalRunOptions;
        private String command;
        private String networkName;
        private boolean randomPorts = false;
        private boolean skipDependencies = false;

        protected Builder() {
            super.setBuilder(this);
        }

        @Override
        public RunConfigurationSettings build() {
            return new RunConfigurationSettingsImpl(this);
        }

        public Builder setStack(Stack stack) {
            this.stack = stack;
            return this;
        }

        public Builder setLoaded(Set<String> loaded) {
            this.loaded = loaded;
            return this;
        }

        public Builder setProjectProperties(Properties projectProperties) {
            this.projectProperties = projectProperties;
            return this;
        }

        public Builder setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public Builder setAdditionalRunOptions(String additionalRunOptions) {
            this.additionalRunOptions = additionalRunOptions;
            return this;
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public Builder setNetworkName(String networkName) {
            this.networkName = networkName;
            return this;
        }

        public Builder setRandomPorts(boolean randomPorts) {
            this.randomPorts = randomPorts;
            return this;
        }

        public Builder setSkipDependencies(boolean skipDependencies) {
            this.skipDependencies = skipDependencies;
            return this;
        }
    }
}

