/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.exception.DockerExecutionException;
import nl.futureedge.maven.docker.executor.Docker;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.RunSettings;

public final class RunExecutable
extends DockerExecutable {
    private final Properties projectProperties;
    private final String runOptions;
    private final boolean daemon;
    private final String image;
    private final String command;
    private final String containerIdProperty;
    private String containerId;

    public RunExecutable(RunSettings settings) {
        super(settings);
        this.projectProperties = settings.getProjectProperties();
        this.runOptions = settings.getRunOptions();
        this.daemon = settings.isDaemon();
        this.image = settings.getImage();
        this.command = settings.getCommand();
        this.containerIdProperty = settings.getContainerIdProperty();
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void execute() throws DockerException {
        this.info("Run configuration: ");
        this.debug("- projectProperties: " + this.projectProperties);
        this.debug("- runOptions: " + this.runOptions);
        this.debug("- daemon: " + this.daemon);
        this.info("- image: " + this.image);
        this.debug("- command: " + this.command);
        this.debug("- containerIdProperty: " + this.containerIdProperty);
        DockerExecutor executor = this.createDockerExecutor();
        this.containerId = this.daemon ? this.doIgnoringFailure(() -> this.runContainer(executor, this.runOptions, this.image, this.command)) : this.doIgnoringFailure(() -> this.executeContainer(executor, this.runOptions, this.image, this.command));
        this.info("ContainerId: " + this.containerId);
        if (this.containerIdProperty != null && !"".equals(this.containerIdProperty.trim())) {
            this.projectProperties.setProperty(this.containerIdProperty, this.containerId);
        }
    }

    private String runContainer(DockerExecutor executor, String runOptions, String image, String command) throws DockerExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("run");
        arguments.addAll(Docker.splitOptions(runOptions));
        arguments.add("-d");
        arguments.add(image);
        if (command != null && !"".equals(command)) {
            arguments.addAll(Docker.splitOptions(command));
        }
        List<String> executionResult = executor.execute(arguments, false, true);
        return executionResult.get(0);
    }

    /*
     * Exception decompiling
     */
    private String executeContainer(DockerExecutor executor, String runOptions, String image, String command) throws DockerExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

