/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.Properties;
import nl.futureedge.maven.docker.support.DockerSettings;

public interface RunSettings
extends DockerSettings {
    public Properties getProjectProperties();

    public String getRunOptions();

    public boolean isDaemon();

    public String getImage();

    public String getCommand();

    public String getContainerIdProperty();

    public static Builder builder() {
        return new Builder();
    }

    public static final class RunSettingsImpl
    extends DockerSettings.DockerSettingsImpl
    implements RunSettings {
        private final Properties projectProperties;
        private final String runOptions;
        private final boolean daemon;
        private final String image;
        private final String command;
        private final String containerIdProperty;

        protected RunSettingsImpl(Builder builder) {
            super(builder);
            this.projectProperties = builder.projectProperties;
            this.runOptions = builder.runOptions;
            this.daemon = builder.daemon;
            this.image = builder.image;
            this.command = builder.command;
            this.containerIdProperty = builder.containerIdProperty;
        }

        @Override
        public Properties getProjectProperties() {
            return this.projectProperties;
        }

        @Override
        public String getRunOptions() {
            return this.runOptions;
        }

        @Override
        public boolean isDaemon() {
            return this.daemon;
        }

        @Override
        public String getImage() {
            return this.image;
        }

        @Override
        public String getCommand() {
            return this.command;
        }

        @Override
        public String getContainerIdProperty() {
            return this.containerIdProperty;
        }
    }

    public static final class Builder
    extends DockerSettings.Builder<Builder> {
        private Properties projectProperties = System.getProperties();
        private String runOptions;
        private boolean daemon = true;
        private String image;
        private String command;
        private String containerIdProperty;

        protected Builder() {
            super.setBuilder(this);
        }

        @Override
        public RunSettings build() {
            return new RunSettingsImpl(this);
        }

        public Builder setProjectProperties(Properties projectProperties) {
            this.projectProperties = projectProperties;
            return this;
        }

        public Builder setRunOptions(String runOptions) {
            this.runOptions = runOptions;
            return this;
        }

        public Builder setDaemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder setImage(String image) {
            this.image = image;
            return this;
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public Builder setContainerIdProperty(String containerIdProperty) {
            this.containerIdProperty = containerIdProperty;
            return this;
        }
    }
}

