/*
 * Decompiled with CFR 0.152.
 */
package nl.futureedge.maven.docker.support;

import java.util.List;
import nl.futureedge.maven.docker.exception.DockerException;
import nl.futureedge.maven.docker.executor.DockerCommands;
import nl.futureedge.maven.docker.executor.DockerExecutor;
import nl.futureedge.maven.docker.support.DockerExecutable;
import nl.futureedge.maven.docker.support.StartContainersSettings;

public final class StartContainersExecutable
extends DockerExecutable {
    private final String filter;

    public StartContainersExecutable(StartContainersSettings settings) {
        super(settings);
        this.filter = settings.getFilter();
    }

    @Override
    public void execute() throws DockerException {
        this.debug("Start containers configuration: ");
        this.debug("- filter: " + this.filter);
        DockerExecutor executor = this.createDockerExecutor();
        List containers = this.doIgnoringFailure(() -> DockerCommands.listContainers(executor, this.filter));
        if (containers != null) {
            for (String container : containers) {
                if ("".equals(container.trim())) continue;
                this.info("Start container: " + container);
                this.doIgnoringFailure(() -> DockerCommands.startContainer(executor, container));
            }
        }
    }
}

