package nl.mirila.example.pojos;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import nl.mirila.model.management.descriptor.ModelDescriptors;
import nl.mirila.model.management.descriptor.ModelsPackageName;
import nl.mirila.model.management.managers.EntityManager;

public class ExamplePojosModule extends AbstractModule {

    @Override
    protected void configure() {
        bindConstant().annotatedWith(ModelsPackageName.class).to(this.getClass().getPackageName());
        bind(ModelDescriptors.class).asEagerSingleton();

        bind(new TypeLiteral<EntityManager<User>>(){});
    }

}
