package nl.mirila.example.pojos;

import static com.fasterxml.jackson.annotation.JsonProperty.Access.AUTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.lang.String;
import java.util.Map;
import nl.mirila.core.datatype.Id;
import nl.mirila.model.core.annotations.AutoGenerated;
import nl.mirila.model.core.annotations.ModelInfo;
import nl.mirila.model.core.annotations.Required;
import nl.mirila.model.core.references.Model;

/**
 * The account of a resource, like a user.
 */
@ModelInfo(
    singular = "Account",
    plural = "Account",
    primaryKeyFields = "accountId"
)
@JsonRootName("Account")
public class Account implements Model {
  /**
   * The internal id of an account.
   */
  @JsonProperty(
      access = AUTO
  )
  @AutoGenerated
  private Id accountId;

  /**
   * The unique account name, like a username.
   */
  @JsonProperty(
      access = AUTO
  )
  @Required
  private String accountName;

  @JsonProperty(
      access = AUTO
  )
  private Map<String, String> tokens;

  public Account() {
  }

  /**
   * Return accountId: The internal id of an account.
   */
  public Id getAccountId() {
    return accountId;
  }

  /**
   * Set accountId: The internal id of an account.
   */
  public void setAccountId(Id accountId) {
    this.accountId = accountId;
  }

  /**
   * Return accountName: The unique account name, like a username.
   */
  public String getAccountName() {
    return accountName;
  }

  /**
   * Set accountName: The unique account name, like a username.
   */
  public void setAccountName(String accountName) {
    if (accountName != null) {
      this.accountName = accountName;
    }
  }

  /**
   * Return tokens: null
   */
  public Map<String, String> getTokens() {
    return tokens;
  }

  /**
   * Set tokens: null
   */
  public void setTokens(Map<String, String> tokens) {
    this.tokens = tokens;
  }

  /**
   * Convenience class that contains all fields names for this model.
   */
  public static final class Fields {
    public static final String ACCOUNT_ID = "accountId";

    public static final String ACCOUNT_NAME = "accountName";

    public static final String TOKENS = "tokens";
  }
}
