package nl.mirila.example.pojos;

import static com.fasterxml.jackson.annotation.JsonProperty.Access.AUTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.lang.Override;
import java.lang.String;
import nl.mirila.core.datatype.Id;
import nl.mirila.model.core.annotations.AutoGenerated;
import nl.mirila.model.core.annotations.ModelInfo;
import nl.mirila.model.core.annotations.Required;
import nl.mirila.model.core.references.Model;

@ModelInfo(
    singular = "User",
    plural = "Users",
    primaryKeyFields = "id"
)
@JsonRootName("User")
public class User implements Model, Person {
  /**
   * The id of the person.
   */
  @JsonProperty(
      access = AUTO
  )
  @AutoGenerated
  private Id id;

  /**
   * The first name of a person.
   */
  @JsonProperty(
      access = AUTO
  )
  private String firstName;

  /**
   * The prefix of the last name of a person.
   */
  @JsonProperty(
      access = AUTO
  )
  private String lastNamePrefix;

  /**
   * The last name of a person.
   */
  @JsonProperty(
      access = AUTO
  )
  @Required
  private String lastName;

  /**
   * The related id of the account
   */
  @JsonProperty(
      access = AUTO
  )
  @Required
  private Id accountId;

  public User() {
  }

  /**
   * Return id: The id of the person.
   */
  @Override
  public Id getId() {
    return id;
  }

  /**
   * Set id: The id of the person.
   */
  @Override
  public void setId(Id id) {
    this.id = id;
  }

  /**
   * Return firstName: The first name of a person.
   */
  @Override
  public String getFirstName() {
    return firstName;
  }

  /**
   * Set firstName: The first name of a person.
   */
  @Override
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  /**
   * Return lastNamePrefix: The prefix of the last name of a person.
   */
  @Override
  public String getLastNamePrefix() {
    return lastNamePrefix;
  }

  /**
   * Set lastNamePrefix: The prefix of the last name of a person.
   */
  @Override
  public void setLastNamePrefix(String lastNamePrefix) {
    this.lastNamePrefix = lastNamePrefix;
  }

  /**
   * Return lastName: The last name of a person.
   */
  @Override
  public String getLastName() {
    return lastName;
  }

  /**
   * Set lastName: The last name of a person.
   */
  @Override
  public void setLastName(String lastName) {
    if (lastName != null) {
      this.lastName = lastName;
    }
  }

  /**
   * Return accountId: The related id of the account
   */
  public Id getAccountId() {
    return accountId;
  }

  /**
   * Set accountId: The related id of the account
   */
  public void setAccountId(Id accountId) {
    if (accountId != null) {
      this.accountId = accountId;
    }
  }

  /**
   * Convenience class that contains all fields names for this model.
   */
  public static final class Fields {
    public static final String ID = "id";

    public static final String FIRST_NAME = "firstName";

    public static final String LAST_NAME_PREFIX = "lastNamePrefix";

    public static final String LAST_NAME = "lastName";

    public static final String ACCOUNT_ID = "accountId";
  }
}
