CREATE TABLE `account` (
  `account_id` INT NOT NULL AUTO_INCREMENT COMMENT 'The internal id of an account.',
  `account_name` VARCHAR(255) NOT NULL COMMENT 'The unique account name, like a username.',
  `tokens` JSON DEFAULT '{}',
  primary key (account_id)
)
COMMENT 'The account of a resource, like a user.'
CHARACTER SET utf8
COLLATE utf8_general_ci;

CREATE TABLE `users` (
  `id` INT NOT NULL AUTO_INCREMENT COMMENT 'The id of the person.',
  `first_name` VARCHAR(255) COMMENT 'The first name of a person.',
  `last_name_prefix` VARCHAR(255) COMMENT 'The prefix of the last name of a person.',
  `last_name` VARCHAR(255) NOT NULL COMMENT 'The last name of a person.',
  `account_id` INT NOT NULL COMMENT 'The related id of the account',
  primary key (id)
)
CHARACTER SET utf8
COLLATE utf8_general_ci;