/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import nl.qbusict.cupboard.BaseCompartment;
import nl.qbusict.cupboard.Cupboard;
import nl.qbusict.cupboard.QueryResultIterable;
import nl.qbusict.cupboard.annotation.Index;
import nl.qbusict.cupboard.convert.EntityConverter;
import nl.qbusict.cupboard.internal.IndexStatement;

@SuppressLint(value={"DefaultLocale"})
public class DatabaseCompartment
extends BaseCompartment {
    private static final String QUERY_BY_ID = "_id = ?";
    private final SQLiteDatabase mDatabase;

    protected DatabaseCompartment(Cupboard cupboard, SQLiteDatabase database) {
        super(cupboard);
        this.mDatabase = database;
    }

    public void createTables() {
        for (Class<?> entity : this.mCupboard.getRegisteredEntities()) {
            EntityConverter<?> converter = this.mCupboard.getEntityConverter(entity);
            this.createNewTable(this.mDatabase, converter.getTable(), converter.getColumns());
        }
    }

    public void upgradeTables() {
        for (Class<?> entity : this.mCupboard.getRegisteredEntities()) {
            EntityConverter<?> converter = this.mCupboard.getEntityConverter(entity);
            this.updateTable(this.mDatabase, converter.getTable(), converter.getColumns());
        }
    }

    public void dropAllTables() {
        for (Class<?> entity : this.mCupboard.getRegisteredEntities()) {
            EntityConverter<?> converter = this.mCupboard.getEntityConverter(entity);
            this.mDatabase.execSQL("DROP TABLE IF EXISTS " + this.quoteTable(converter.getTable()));
        }
    }

    public void dropAllIndices() {
        for (Class<?> entity : this.mCupboard.getRegisteredEntities()) {
            this.dropIndices(entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndices(Class<?> entity) {
        String table = this.mCupboard.getTable(entity);
        Cursor indices = this.mDatabase.rawQuery("select name, sql from sqlite_master where type = 'index' and tbl_name = '" + table + '\'', null);
        try {
            while (indices.moveToNext()) {
                String name = indices.getString(0);
                this.mDatabase.execSQL("drop index '" + name + "'");
            }
        }
        finally {
            indices.close();
        }
    }

    public <T> T get(Class<T> entityClass, long id) {
        return this.query(entityClass).byId(id).get();
    }

    public <T> T get(T object) throws IllegalArgumentException {
        EntityConverter<?> converter = this.getConverter(object.getClass());
        Long id = converter.getId(object);
        if (id != null) {
            return (T)this.get(object.getClass(), converter.getId(object));
        }
        throw new IllegalArgumentException("id of entity " + object.getClass() + " is not set");
    }

    public <T> QueryBuilder<T> query(Class<T> entityClass) {
        return new QueryBuilder<T>(entityClass, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object ... entities) {
        boolean mNestedTransaction = this.mDatabase.inTransaction();
        this.mDatabase.beginTransaction();
        try {
            for (Object entity : entities) {
                this.put((T)entity);
                if (mNestedTransaction) continue;
                this.mDatabase.yieldIfContendedSafely();
            }
            this.mDatabase.setTransactionSuccessful();
        }
        finally {
            this.mDatabase.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Collection<?> entities) {
        boolean mNestedTransaction = this.mDatabase.inTransaction();
        this.mDatabase.beginTransaction();
        try {
            for (Object entity : entities) {
                this.put((T)entity);
                if (mNestedTransaction) continue;
                this.mDatabase.yieldIfContendedSafely();
            }
            this.mDatabase.setTransactionSuccessful();
        }
        finally {
            this.mDatabase.endTransaction();
        }
    }

    public <T> long put(T entity) {
        EntityConverter<?> converter = this.getConverter(entity.getClass());
        ContentValues values = new ContentValues();
        converter.toValues(entity, values);
        Long id = values.getAsLong("_id");
        long insertedId = this.put(entity.getClass(), values);
        if (id == null) {
            converter.setId(insertedId, entity);
        }
        return id == null ? insertedId : id;
    }

    public long put(Class<?> entityClass, ContentValues values) {
        EntityConverter<?> converter = this.getConverter(entityClass);
        Long id = values.getAsLong("_id");
        if (id != null) {
            this.mDatabase.replaceOrThrow(this.quoteTable(converter.getTable()), "_id", values);
            return id;
        }
        id = this.mDatabase.insertOrThrow(this.quoteTable(converter.getTable()), "_id", values);
        return id;
    }

    public int update(Class<?> entityClass, ContentValues values) {
        EntityConverter<?> converter = this.getConverter(entityClass);
        if (values.containsKey("_id")) {
            return this.mDatabase.update(this.quoteTable(converter.getTable()), values, QUERY_BY_ID, new String[]{values.getAsString("_id")});
        }
        return this.mDatabase.update(this.quoteTable(converter.getTable()), values, null, null);
    }

    public int update(Class<?> entityClass, ContentValues values, String selection, String ... selectionArgs) {
        EntityConverter<?> converter = this.getConverter(entityClass);
        return this.mDatabase.update(this.quoteTable(converter.getTable()), values, selection, selectionArgs);
    }

    public <T> boolean delete(T entity) {
        Class<?> clz = entity.getClass();
        EntityConverter<?> converter = this.getConverter(clz);
        Long id = converter.getId(entity);
        if (id != null) {
            return this.delete(clz, QUERY_BY_ID, String.valueOf(id)) > 0;
        }
        return false;
    }

    public boolean delete(Class<?> entityClass, long id) {
        EntityConverter<?> converter = this.getConverter(entityClass);
        return this.mDatabase.delete(this.quoteTable(converter.getTable()), QUERY_BY_ID, new String[]{String.valueOf(id)}) > 0;
    }

    public int delete(Class<?> entityClass, String selection, String ... selectionArgs) {
        EntityConverter<?> converter = this.getConverter(entityClass);
        return this.mDatabase.delete(this.quoteTable(converter.getTable()), selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateTable(SQLiteDatabase db, String table, List<EntityConverter.Column> cols) {
        Cursor cursor = db.rawQuery("pragma table_info('" + table + "')", null);
        try {
            if (cursor.getCount() == 0) {
                boolean bl = this.createNewTable(db, table, cols);
                return bl;
            }
            boolean bl = this.updateTable(db, table, cursor, cols);
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    boolean updateTable(SQLiteDatabase db, String table, Cursor tableInfo, List<EntityConverter.Column> cols) {
        Locale locale = Locale.US;
        HashMap<String, EntityConverter.Column> columns = new HashMap<String, EntityConverter.Column>(cols.size());
        for (EntityConverter.Column col : cols) {
            if (col.type == EntityConverter.ColumnType.JOIN) continue;
            columns.put(col.name.toLowerCase(locale), col);
        }
        int index = tableInfo.getColumnIndex("name");
        while (tableInfo.moveToNext()) {
            columns.remove(tableInfo.getString(index).toLowerCase(locale));
        }
        boolean updated = false;
        if (!columns.isEmpty()) {
            updated = true;
            for (EntityConverter.Column column : columns.values()) {
                db.execSQL("alter table '" + table + "' add column '" + column.name + "' " + column.type.toString());
            }
        }
        return updated |= this.diffAndUpdateIndexes(db, table, cols);
    }

    private boolean diffAndUpdateIndexes(SQLiteDatabase db, String table, List<EntityConverter.Column> cols) {
        boolean updated = false;
        Cursor indexesInDbCursor = db.rawQuery("select name, sql from sqlite_master where type = 'index' and tbl_name = '" + table + "' and name like '" + "_cb" + "%'", null);
        HashMap<String, String> indexesInDb = new HashMap<String, String>();
        while (indexesInDbCursor.moveToNext()) {
            indexesInDb.put(indexesInDbCursor.getString(0), indexesInDbCursor.getString(1));
        }
        indexesInDbCursor.close();
        IndexStatement.Builder builder = new IndexStatement.Builder();
        for (EntityConverter.Column col : cols) {
            Index index;
            if (col.type == EntityConverter.ColumnType.JOIN || (index = col.index) == null) continue;
            builder.addIndexedColumn(table, col.name, index);
        }
        Map<String, IndexStatement> indexesOfEntity = builder.buildAsMap();
        Set oldSet = indexesInDb.keySet();
        Set<String> newSet = indexesOfEntity.keySet();
        HashSet toRemove = new HashSet(oldSet);
        toRemove.removeAll(newSet);
        for (Object name : toRemove) {
            db.execSQL("drop index if exists " + (String)name);
            updated |= true;
        }
        HashSet<String> toAdd = new HashSet<String>(newSet);
        toAdd.removeAll(oldSet);
        for (String name : toAdd) {
            db.execSQL(indexesOfEntity.get(name).getCreationSql(table));
            updated |= true;
        }
        HashSet<String> toPossiblyKeep = new HashSet<String>(newSet);
        toPossiblyKeep.retainAll(oldSet);
        for (String name : toPossiblyKeep) {
            String newSql;
            String oldSql = (String)indexesInDb.get(name);
            if (oldSql.equalsIgnoreCase(newSql = indexesOfEntity.get(name).getCreationSql(table, false))) continue;
            db.execSQL("drop index if exists " + name);
            db.execSQL(newSql);
            updated |= true;
        }
        return updated;
    }

    boolean createNewTable(SQLiteDatabase db, String table, List<EntityConverter.Column> cols) {
        StringBuilder sql = new StringBuilder("create table '").append(table).append("' (_id integer primary key autoincrement");
        IndexStatement.Builder builder = new IndexStatement.Builder();
        for (EntityConverter.Column col : cols) {
            Index index;
            if (col.type == EntityConverter.ColumnType.JOIN) continue;
            String name = col.name;
            if (!name.equals("_id")) {
                sql.append(", '").append(name).append("'");
                sql.append(" ").append(col.type.toString());
            }
            if ((index = col.index) == null) continue;
            builder.addIndexedColumn(table, name, index);
        }
        sql.append(");");
        db.execSQL(sql.toString());
        for (IndexStatement stmt : builder.build()) {
            db.execSQL(stmt.getCreationSql(table));
        }
        return true;
    }

    private <T> QueryResultIterable<T> query(Class<T> entityClass, String[] projection, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit, boolean distinct) {
        EntityConverter<T> translator = this.getConverter(entityClass);
        Cursor cursor = this.mDatabase.query(distinct, this.quoteTable(translator.getTable()), projection, selection, selectionArgs, groupBy, having, orderBy, limit);
        return new QueryResultIterable<T>(cursor, translator);
    }

    private String quoteTable(String table) {
        return "'" + table + "'";
    }

    public static class QueryBuilder<T> {
        private final Class<T> mEntityClass;
        private final DatabaseCompartment mCompartment;
        private String mSelection;
        private String[] mSelectionArgs;
        private String mOrder;
        private String mGroup;
        private String mHaving;
        private String[] mProjection;
        private String mLimit = null;
        private String mOffset = null;
        private boolean mDistinct = false;

        QueryBuilder(Class<T> entityClass, DatabaseCompartment compartment) {
            this.mEntityClass = entityClass;
            this.mCompartment = compartment;
        }

        public QueryBuilder<T> withSelection(String selection, String ... args) {
            this.mSelection = selection;
            this.mSelectionArgs = args;
            return this;
        }

        public QueryBuilder<T> orderBy(String order) {
            this.mOrder = order;
            return this;
        }

        public QueryBuilder<T> groupBy(String group) {
            this.mGroup = group;
            return this;
        }

        public QueryBuilder<T> having(String having) {
            this.mHaving = having;
            return this;
        }

        public QueryBuilder<T> withProjection(String ... projection) {
            this.mProjection = projection;
            return this;
        }

        public QueryBuilder<T> byId(long id) {
            this.mSelection = DatabaseCompartment.QUERY_BY_ID;
            this.mSelectionArgs = new String[]{String.valueOf(id)};
            this.limit(1);
            return this;
        }

        public QueryBuilder<T> limit(int limit) {
            if (limit < 1) {
                throw new IllegalArgumentException("Limit must be greater or equal to 1");
            }
            this.mLimit = String.valueOf(limit);
            return this;
        }

        public QueryBuilder<T> offset(int offset) {
            if (offset < 1) {
                throw new IllegalArgumentException("Offset must be greater or equal to 1");
            }
            this.mOffset = String.valueOf(offset);
            return this;
        }

        public QueryBuilder<T> distinct() {
            this.mDistinct = true;
            return this;
        }

        public QueryResultIterable<T> query() {
            if (this.mLimit != null && this.mOffset != null) {
                this.mLimit = String.format("%s,%s", this.mOffset, this.mLimit);
            } else if (this.mOffset != null) {
                this.mLimit = String.format("%s,%d", this.mOffset, Long.MAX_VALUE);
            }
            return this.mCompartment.query(this.mEntityClass, this.mProjection, this.mSelection, this.mSelectionArgs, this.mGroup, this.mHaving, this.mOrder, this.mLimit, this.mDistinct);
        }

        public Cursor getCursor() {
            return this.query().getCursor();
        }

        public T get() {
            return this.query().get();
        }

        public List<T> list() {
            return this.query().list();
        }
    }
}

