/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.convert;

import android.content.ContentValues;
import android.database.Cursor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.qbusict.cupboard.Cupboard;
import nl.qbusict.cupboard.annotation.Column;
import nl.qbusict.cupboard.annotation.Ignore;
import nl.qbusict.cupboard.annotation.Index;
import nl.qbusict.cupboard.convert.EntityConverter;
import nl.qbusict.cupboard.convert.FieldConverter;

public class ReflectiveEntityConverter<T>
implements EntityConverter<T> {
    protected final Cupboard mCupboard;
    private final List<EntityConverter.Column> mColumns;
    private final Class<T> mClass;
    private final Property[] mProperties;
    private final boolean mUseAnnotations;
    private Property mIdProperty;

    public ReflectiveEntityConverter(Cupboard cupboard, Class<T> entityClass) {
        this(cupboard, entityClass, Collections.emptyList(), Collections.emptyList());
    }

    public ReflectiveEntityConverter(Cupboard cupboard, Class<T> entityClass, Collection<String> ignoredFieldsNames) {
        this(cupboard, entityClass, ignoredFieldsNames, Collections.emptyList());
    }

    public ReflectiveEntityConverter(Cupboard cupboard, Class<T> entityClass, Collection<String> ignoredFieldNames, Collection<EntityConverter.Column> additionalColumns) {
        this.mCupboard = cupboard;
        this.mUseAnnotations = cupboard.isUseAnnotations();
        Field[] fields = this.getAllFields(entityClass);
        ArrayList<EntityConverter.Column> columns = new ArrayList<EntityConverter.Column>(fields.length);
        this.mClass = entityClass;
        ArrayList<Property> properties = new ArrayList<Property>();
        for (Field field : fields) {
            if (ignoredFieldNames.contains(field.getName()) || this.isIgnored(field)) continue;
            Type type = field.getGenericType();
            FieldConverter<?> converter = this.getFieldConverter(field);
            if (converter == null) {
                throw new IllegalArgumentException("Do not know how to convert field " + field.getName() + " in entity " + entityClass.getName() + " of type " + type);
            }
            if (converter.getColumnType() == null) continue;
            Property prop = new Property();
            prop.field = field;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            prop.name = this.getColumn(field);
            prop.type = field.getType();
            prop.fieldConverter = converter;
            prop.columnType = this.isReadOnlyColumn(field) ? EntityConverter.ColumnType.JOIN : converter.getColumnType();
            properties.add(prop);
            if ("_id".equals(prop.name)) {
                this.mIdProperty = prop;
            }
            columns.add(new EntityConverter.Column(prop.name, prop.columnType, this.getIndexes(field)));
        }
        columns.addAll(additionalColumns);
        this.mColumns = Collections.unmodifiableList(columns);
        this.mProperties = properties.toArray(new Property[properties.size()]);
    }

    private static String getTable(Class<?> clz) {
        return clz.getSimpleName();
    }

    protected FieldConverter<?> getFieldConverter(Field field) {
        return this.mCupboard.getFieldConverter(field.getGenericType());
    }

    private Field[] getAllFields(Class<?> clz) {
        if (clz.getSuperclass() == null) {
            return clz.getDeclaredFields();
        }
        ArrayList<Field> fields = new ArrayList<Field>(256);
        Class<?> c = clz;
        do {
            Field[] f = c.getDeclaredFields();
            fields.addAll(Arrays.asList(f));
        } while ((c = c.getSuperclass()) != null);
        Field[] result = new Field[fields.size()];
        return fields.toArray(result);
    }

    protected boolean isIgnored(Field field) {
        boolean ignored;
        int modifiers = field.getModifiers();
        boolean bl = ignored = Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers);
        if (this.mUseAnnotations) {
            ignored = ignored || field.getAnnotation(Ignore.class) != null;
        }
        return ignored;
    }

    @Override
    public T fromCursor(Cursor cursor) {
        try {
            T result = this.mClass.newInstance();
            int cols = cursor.getColumnCount();
            for (int index = 0; index < this.mProperties.length && index < cols; ++index) {
                Property prop = this.mProperties[index];
                Class<?> type = prop.type;
                if (cursor.isNull(index)) {
                    if (type.isPrimitive()) continue;
                    prop.field.set(result, null);
                    continue;
                }
                prop.field.set(result, prop.fieldConverter.fromCursorValue(cursor, index));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void toValues(T object, ContentValues values) {
        for (Property prop : this.mProperties) {
            if (prop.columnType == EntityConverter.ColumnType.JOIN) continue;
            try {
                Object value = prop.field.get(object);
                if (value == null) {
                    if (prop.name.equals("_id")) continue;
                    values.putNull(prop.name);
                    continue;
                }
                prop.fieldConverter.toContentValue(value, prop.name, values);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<EntityConverter.Column> getColumns() {
        return this.mColumns;
    }

    protected boolean isReadOnlyColumn(Field field) {
        return false;
    }

    @Override
    public void setId(Long id, T instance) {
        if (this.mIdProperty != null) {
            try {
                this.mIdProperty.field.set(instance, id);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Long getId(T instance) {
        if (this.mIdProperty != null) {
            try {
                return (Long)this.mIdProperty.field.get(instance);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    protected String getColumn(Field field) {
        Column column;
        if (this.mUseAnnotations && (column = field.getAnnotation(Column.class)) != null) {
            return column.value();
        }
        return field.getName();
    }

    protected Index getIndexes(Field field) {
        Index index;
        if (this.mUseAnnotations && (index = field.getAnnotation(Index.class)) != null) {
            return index;
        }
        return null;
    }

    @Override
    public String getTable() {
        return ReflectiveEntityConverter.getTable(this.mClass);
    }

    private static class Property {
        Field field;
        String name;
        Class<?> type;
        FieldConverter<Object> fieldConverter;
        EntityConverter.ColumnType columnType;

        private Property() {
        }
    }
}

