/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.internal.convert;

import android.content.ContentValues;
import android.database.Cursor;
import java.lang.reflect.Type;
import nl.qbusict.cupboard.Cupboard;
import nl.qbusict.cupboard.convert.EntityConverter;
import nl.qbusict.cupboard.convert.FieldConverter;
import nl.qbusict.cupboard.convert.FieldConverterFactory;

public class EntityFieldConverterFactory
implements FieldConverterFactory {
    @Override
    public FieldConverter<?> create(Cupboard cupboard, Type type) {
        if (!(type instanceof Class)) {
            return null;
        }
        if (cupboard.isRegisteredEntity((Class)type)) {
            EntityConverter converter = cupboard.getEntityConverter((Class)type);
            return new EntityFieldConverter((Class)type, converter);
        }
        return null;
    }

    private static class EntityFieldConverter
    implements FieldConverter<Object> {
        private final Class<Object> entityClass;
        private final EntityConverter<Object> mEntityConverter;

        public EntityFieldConverter(Class<Object> clz, EntityConverter<?> entityConverter) {
            this.mEntityConverter = entityConverter;
            this.entityClass = clz;
        }

        @Override
        public Object fromCursorValue(Cursor cursor, int columnIndex) {
            Object entity;
            long id = cursor.getLong(columnIndex);
            try {
                entity = this.entityClass.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            this.mEntityConverter.setId(id, entity);
            return entity;
        }

        @Override
        public void toContentValue(Object value, String key, ContentValues values) {
            values.put(key, this.mEntityConverter.getId(value));
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.INTEGER;
        }
    }
}

