/*
 * Decompiled with CFR 0.152.
 */
package nl.tradecloud.kafka;

import akka.actor.ActorSystem;
import akka.protobuf.ByteString;
import akka.remote.WireFormats;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import org.apache.kafka.common.errors.SerializationException;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

public final class KafkaMessageSerializer$ {
    public static final KafkaMessageSerializer$ MODULE$;

    static {
        new KafkaMessageSerializer$();
    }

    public Object deserialize(ActorSystem system, WireFormats.SerializedMessage messageProtocol) {
        return ((Serialization)SerializationExtension$.MODULE$.apply(system)).deserialize(messageProtocol.getMessage().toByteArray(), messageProtocol.getSerializerId(), messageProtocol.hasMessageManifest() ? messageProtocol.getMessageManifest().toStringUtf8() : "").get();
    }

    public WireFormats.SerializedMessage serialize(ActorSystem system, Object message) {
        Serialization s = (Serialization)SerializationExtension$.MODULE$.apply(system);
        Serializer serializer = s.findSerializerFor(message);
        WireFormats.SerializedMessage.Builder builder = WireFormats.SerializedMessage.newBuilder();
        try {
            BoxedUnit boxedUnit;
            builder.setMessage(ByteString.copyFrom((byte[])serializer.toBinary(message)));
            builder.setSerializerId(serializer.identifier());
            Serializer serializer2 = serializer;
            if (serializer2 instanceof SerializerWithStringManifest) {
                String manifest;
                SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
                String string = manifest = serializerWithStringManifest.manifest(message);
                String string2 = "";
                boxedUnit = !(string != null ? !string.equals(string2) : string2 != null) ? BoxedUnit.UNIT : builder.setMessageManifest(ByteString.copyFromUtf8((String)manifest));
            } else {
                boxedUnit = serializer.includeManifest() ? builder.setMessageManifest(ByteString.copyFromUtf8((String)message.getClass().getName())) : BoxedUnit.UNIT;
            }
            return builder.build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new SerializationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to serialize akka message [", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"using serializer [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serializer.getClass()}))).toString(), e);
        }
    }

    private KafkaMessageSerializer$() {
        MODULE$ = this;
    }
}

