/*
 * Decompiled with CFR 0.152.
 */
package nl.tradecloud.kafka;

import akka.Done;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ScalaActorRef;
import akka.actor.SupervisorStrategy$;
import akka.actor.package$;
import akka.kafka.ProducerSettings;
import akka.kafka.ProducerSettings$;
import akka.pattern.BackoffSupervisor$;
import akka.stream.Materializer;
import nl.tradecloud.kafka.KafkaPublisher$;
import nl.tradecloud.kafka.KafkaPublisherActor$;
import nl.tradecloud.kafka.command.Publish;
import nl.tradecloud.kafka.config.KafkaConfig;
import nl.tradecloud.kafka.config.KafkaConfig$;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0001%\u0011abS1gW\u0006\u0004VO\u00197jg\",'O\u0003\u0002\u0004\t\u0005)1.\u00194lC*\u0011QAB\u0001\u000biJ\fG-Z2m_V$'\"A\u0004\u0002\u00059d7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\rML8\u000f^3n!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#A\u0003bGR|'OC\u0001\u0018\u0003\u0011\t7n[1\n\u0005e!\"aC!di>\u00148+_:uK6D\u0001b\u0007\u0001\u0003\u0002\u0003\u0006Y\u0001H\u0001\u0004[\u0006$\bCA\u000f!\u001b\u0005q\"BA\u0010\u0017\u0003\u0019\u0019HO]3b[&\u0011\u0011E\b\u0002\r\u001b\u0006$XM]5bY&TXM\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0006I\u000591m\u001c8uKb$\bCA\n&\u0013\t1CCA\bBGR|'OU3g\r\u0006\u001cGo\u001c:z\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\u0011!f\f\u000b\u0004W5r\u0003C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000e(\u0001\ba\u0002\"B\u0012(\u0001\b!\u0003\"B\t(\u0001\u0004\u0011\u0002bB\u0019\u0001\u0005\u0004%\u0019AM\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014X#A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0005Yb\u0011AC2p]\u000e,(O]3oi&\u0011\u0001(\u000e\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDaA\u000f\u0001!\u0002\u0013\u0019\u0014a\u00033jgB\fGo\u00195fe\u0002Bq\u0001\u0010\u0001C\u0002\u0013\u0005Q(A\u0006lC\u001a\\\u0017mQ8oM&<W#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005\u0013\u0011AB2p]\u001aLw-\u0003\u0002D\u0001\nY1*\u00194lC\u000e{gNZ5h\u0011\u0019)\u0005\u0001)A\u0005}\u0005a1.\u00194lC\u000e{gNZ5hA!Aq\t\u0001EC\u0002\u0013%\u0001*A\u0006qk\nd\u0017n\u001d5fe&#W#A%\u0011\u0005-Q\u0015BA&\r\u0005\rIe\u000e\u001e\u0005\t\u001b\u0002A\t\u0011)Q\u0005\u0013\u0006a\u0001/\u001e2mSNDWM]%eA!)q\n\u0001C\u0005!\u0006\t\u0002/\u001e2mSNDWM]*fiRLgnZ:\u0016\u0003E\u0003BA\u0015+W=6\t1K\u0003\u0002\u0004-%\u0011Qk\u0015\u0002\u0011!J|G-^2feN+G\u000f^5oON\u0004\"a\u0016/\u000e\u0003aS!!\u0017.\u0002\t1\fgn\u001a\u0006\u00027\u0006!!.\u0019<b\u0013\ti\u0006L\u0001\u0004TiJLgn\u001a\t\u0004\u0017}\u000b\u0017B\u00011\r\u0005\u0015\t%O]1z!\tY!-\u0003\u0002d\u0019\t!!)\u001f;f\u0011\u001d)\u0007A1A\u0005\n\u0019\fa\u0002];cY&\u001c\b.\u001a:Qe>\u00048/F\u0001h!\t\u0019\u0002.\u0003\u0002j)\t)\u0001K]8qg\"11\u000e\u0001Q\u0001\n\u001d\fq\u0002];cY&\u001c\b.\u001a:Qe>\u00048\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0003g\u0003U\u0011\u0017mY6pM\u001a\u0004VO\u00197jg\",'\u000f\u0015:paNDaa\u001c\u0001!\u0002\u00139\u0017A\u00062bG.|gM\u001a)vE2L7\u000f[3s!J|\u0007o\u001d\u0011\t\u000fE\u0004!\u0019!C\u0005e\u0006a\u0001/\u001e2mSND\u0017i\u0019;peV\t1\u000f\u0005\u0002\u0014i&\u0011Q\u000f\u0006\u0002\t\u0003\u000e$xN\u001d*fM\"1q\u000f\u0001Q\u0001\nM\fQ\u0002];cY&\u001c\b.Q2u_J\u0004\u0003\"B=\u0001\t\u0003Q\u0018a\u00029vE2L7\u000f\u001b\u000b\u0006w\u0006\u0015\u0011Q\u0003\t\u0004iqt\u0018BA?6\u0005\u00191U\u000f^;sKB\u0019q0!\u0001\u000e\u0003YI1!a\u0001\u0017\u0005\u0011!uN\\3\t\u000f\u0005\u001d\u0001\u00101\u0001\u0002\n\u0005)Ao\u001c9jGB!\u00111BA\t\u001d\rY\u0011QB\u0005\u0004\u0003\u001fa\u0011A\u0002)sK\u0012,g-C\u0002^\u0003'Q1!a\u0004\r\u0011\u0019\t9\u0002\u001fa\u0001\u0015\u0005\u0019Qn]4\b\u000f\u0005m!\u0001#\u0001\u0002\u001e\u0005q1*\u00194lCB+(\r\\5tQ\u0016\u0014\bc\u0001\u0017\u0002 \u00191\u0011A\u0001E\u0001\u0003C\u00192!a\b\u000b\u0011\u001dA\u0013q\u0004C\u0001\u0003K!\"!!\b\t\u0015\u0005%\u0012q\u0004b\u0001\n\u0013\tY#A\u000eLC\u001a\\\u0017m\u00117jK:$\u0018\nZ*fcV,gnY3Ok6\u0014WM]\u000b\u0003\u0003[\u0001B!a\f\u0002<5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0004bi>l\u0017n\u0019\u0006\u0004m\u0005]\"bAA\u001d5\u0006!Q\u000f^5m\u0013\u0011\ti$!\r\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011%\t\t%a\b!\u0002\u0013\ti#\u0001\u000fLC\u001a\\\u0017m\u00117jK:$\u0018\nZ*fcV,gnY3Ok6\u0014WM\u001d\u0011")
public class KafkaPublisher {
    private final ActorSystem system;
    private final ExecutionContext dispatcher;
    private final KafkaConfig kafkaConfig;
    private int publisherId;
    private final Props publisherProps;
    private final Props backoffPublisherProps;
    private final ActorRef publishActor;
    private volatile boolean bitmap$0;

    private int publisherId$lzycompute() {
        KafkaPublisher kafkaPublisher = this;
        synchronized (kafkaPublisher) {
            if (!this.bitmap$0) {
                this.publisherId = KafkaPublisher$.MODULE$.nl$tradecloud$kafka$KafkaPublisher$$KafkaClientIdSequenceNumber().getAndIncrement();
                this.bitmap$0 = true;
            }
            return this.publisherId;
        }
    }

    public ExecutionContext dispatcher() {
        return this.dispatcher;
    }

    public KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    private int publisherId() {
        return this.bitmap$0 ? this.publisherId : this.publisherId$lzycompute();
    }

    private ProducerSettings<String, byte[]> publisherSettings() {
        StringSerializer keySerializer = new StringSerializer();
        ByteArraySerializer valueSerializer = new ByteArraySerializer();
        return ProducerSettings$.MODULE$.apply(this.system, (Serializer)keySerializer, (Serializer)valueSerializer).withBootstrapServers(this.kafkaConfig().brokers());
    }

    private Props publisherProps() {
        return this.publisherProps;
    }

    private Props backoffPublisherProps() {
        return this.backoffPublisherProps;
    }

    private ActorRef publishActor() {
        return this.publishActor;
    }

    public Future<Done> publish(String topic, Object msg) {
        Promise completed = Promise$.MODULE$.apply();
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.publishActor());
        Publish x$1 = new Publish(topic, msg, (Promise<Done>)completed);
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$1);
        qual$1.$bang((Object)x$1, x$2);
        return completed.future();
    }

    public KafkaPublisher(ActorSystem system, Materializer mat, ActorRefFactory context) {
        this.system = system;
        this.dispatcher = system.dispatchers().lookup("dispatchers.kafka-dispatcher");
        this.kafkaConfig = KafkaConfig$.MODULE$.apply(system.settings().config());
        this.publisherProps = KafkaPublisherActor$.MODULE$.props(this.kafkaConfig(), this.publisherSettings(), mat, this.dispatcher());
        this.backoffPublisherProps = BackoffSupervisor$.MODULE$.propsWithSupervisorStrategy(this.publisherProps(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaPublisherActor", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.publisherId())})), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds(), 1.0, SupervisorStrategy$.MODULE$.stoppingStrategy());
        this.publishActor = context.actorOf(this.backoffPublisherProps(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaBackoffPublisher", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.publisherId())})));
    }
}

