/*
 * Decompiled with CFR 0.152.
 */
package nl.tradecloud.kafka;

import akka.Done;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.kafka.ConsumerSettings;
import akka.kafka.ConsumerSettings$;
import akka.pattern.Backoff$;
import akka.pattern.BackoffSupervisor$;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import nl.tradecloud.kafka.KafkaMessage;
import nl.tradecloud.kafka.KafkaSubscriber$;
import nl.tradecloud.kafka.KafkaSubscriberActor$;
import nl.tradecloud.kafka.command.Subscribe;
import nl.tradecloud.kafka.config.KafkaConfig;
import nl.tradecloud.kafka.config.KafkaConfig$;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u0001%\u0011qbS1gW\u0006\u001cVOY:de&\u0014WM\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\u0015Q\u0014\u0018\rZ3dY>,HMC\u0001\b\u0003\tqGn\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u0003\u0013\u0003%\u0019XOY:de&\u0014W\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0005\u000591m\\7nC:$\u0017BA\f\u0015\u0005%\u0019VOY:de&\u0014W\r\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0019\u0019\u0018p\u001d;f[B\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006C\u000e$xN\u001d\u0006\u0002?\u0005!\u0011m[6b\u0013\t\tCDA\u0006BGR|'oU=ti\u0016l\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b1\u0002\u0013\u0002\u00075\fG\u000f\u0005\u0002&Q5\taE\u0003\u0002(=\u000511\u000f\u001e:fC6L!!\u000b\u0014\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\t\u0011-\u0002!\u0011!Q\u0001\f1\nqaY8oi\u0016DH\u000f\u0005\u0002\u001c[%\u0011a\u0006\b\u0002\u0010\u0003\u000e$xN\u001d*fM\u001a\u000b7\r^8ss\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"2AM\u001c9)\r\u0019TG\u000e\t\u0003i\u0001i\u0011A\u0001\u0005\u0006G=\u0002\u001d\u0001\n\u0005\u0006W=\u0002\u001d\u0001\f\u0005\u0006#=\u0002\rA\u0005\u0005\u00063=\u0002\rA\u0007\u0005\bu\u0001\u0011\r\u0011b\u0001<\u0003)!\u0017n\u001d9bi\u000eDWM]\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011q\bD\u0001\u000bG>t7-\u001e:sK:$\u0018BA!?\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH\u000f\u0003\u0004D\u0001\u0001\u0006I\u0001P\u0001\fI&\u001c\b/\u0019;dQ\u0016\u0014\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0017-\fgm[1D_:4\u0017nZ\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JA\u0001\u0007G>tg-[4\n\u00051K%aC&bM.\f7i\u001c8gS\u001eDaA\u0014\u0001!\u0002\u00139\u0015\u0001D6bM.\f7i\u001c8gS\u001e\u0004\u0003\u0002\u0003)\u0001\u0011\u000b\u0007I\u0011B)\u0002\u0015\r|gn];nKJLE-F\u0001S!\tY1+\u0003\u0002U\u0019\t\u0019\u0011J\u001c;\t\u0011Y\u0003\u0001\u0012!Q!\nI\u000b1bY8ogVlWM]%eA!)\u0001\f\u0001C\u00053\u0006\u00012m\u001c8tk6,'oU3ui&twm]\u000b\u00025B!1,X0h\u001b\u0005a&BA\u0002\u001f\u0013\tqFL\u0001\tD_:\u001cX/\\3s'\u0016$H/\u001b8hgB\u0011\u0001-Z\u0007\u0002C*\u0011!mY\u0001\u0005Y\u0006twMC\u0001e\u0003\u0011Q\u0017M^1\n\u0005\u0019\f'AB*ue&tw\rE\u0002\fQ*L!!\u001b\u0007\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-Y\u0017B\u00017\r\u0005\u0011\u0011\u0015\u0010^3\t\u000b9\u0004A\u0011A8\u0002\u0017\u0005$H*Z1ti>s7-\u001a\u000b\u0003a^\u00042!P9t\u0013\t\u0011hH\u0001\u0004GkR,(/\u001a\t\u0003iVl\u0011AH\u0005\u0003mz\u0011A\u0001R8oK\")\u00010\u001ca\u0001s\u0006!a\r\\8xa\rQ\u00181\u0002\t\bwz\f\ta]A\u0004\u001b\u0005a(BA?'\u0003!\u00198-\u00197bINd\u0017BA@}\u0005\u00111En\\<\u0011\u0007Q\n\u0019!C\u0002\u0002\u0006\t\u0011AbS1gW\u0006lUm]:bO\u0016\u0004B!!\u0003\u0002\f1\u0001AaCA\u0007o\u0006\u0005\t\u0011!B\u0001\u0003\u001f\u00111a\u0018\u00132#\u0011\t\t\"a\u0006\u0011\u0007-\t\u0019\"C\u0002\u0002\u00161\u0011qAT8uQ&tw\rE\u0002\f\u00033I1!a\u0007\r\u0005\r\te._\u0004\b\u0003?\u0011\u0001\u0012AA\u0011\u0003=Y\u0015MZ6b'V\u00147o\u0019:jE\u0016\u0014\bc\u0001\u001b\u0002$\u00191\u0011A\u0001E\u0001\u0003K\u00192!a\t\u000b\u0011\u001d\u0001\u00141\u0005C\u0001\u0003S!\"!!\t\t\u0015\u00055\u00121\u0005b\u0001\n\u0013\ty#A\u000eLC\u001a\\\u0017m\u00117jK:$\u0018\nZ*fcV,gnY3Ok6\u0014WM]\u000b\u0003\u0003c\u0001B!a\r\u0002@5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$\u0001\u0004bi>l\u0017n\u0019\u0006\u0004\u007f\u0005m\"bAA\u001fG\u0006!Q\u000f^5m\u0013\u0011\t\t%!\u000e\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011%\t)%a\t!\u0002\u0013\t\t$\u0001\u000fLC\u001a\\\u0017m\u00117jK:$\u0018\nZ*fcV,gnY3Ok6\u0014WM\u001d\u0011")
public class KafkaSubscriber {
    private final Subscribe subscribe;
    private final ActorSystem system;
    private final Materializer mat;
    private final ActorRefFactory context;
    private final ExecutionContext dispatcher;
    private final KafkaConfig kafkaConfig;
    private int consumerId;
    private volatile boolean bitmap$0;

    private int consumerId$lzycompute() {
        KafkaSubscriber kafkaSubscriber = this;
        synchronized (kafkaSubscriber) {
            if (!this.bitmap$0) {
                this.consumerId = KafkaSubscriber$.MODULE$.nl$tradecloud$kafka$KafkaSubscriber$$KafkaClientIdSequenceNumber().getAndIncrement();
                this.bitmap$0 = true;
            }
            return this.consumerId;
        }
    }

    public ExecutionContext dispatcher() {
        return this.dispatcher;
    }

    private KafkaConfig kafkaConfig() {
        return this.kafkaConfig;
    }

    private int consumerId() {
        return this.bitmap$0 ? this.consumerId : this.consumerId$lzycompute();
    }

    private ConsumerSettings<String, byte[]> consumerSettings() {
        StringDeserializer keyDeserializer = new StringDeserializer();
        ByteArrayDeserializer valueDeserializer = new ByteArrayDeserializer();
        return ConsumerSettings$.MODULE$.apply(this.system, (Deserializer)keyDeserializer, (Deserializer)valueDeserializer).withBootstrapServers(this.kafkaConfig().brokers()).withGroupId(this.subscribe.group()).withClientId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.subscribe.serviceName(), BoxesRunTime.boxToInteger((int)this.consumerId())})));
    }

    public Future<Done> atLeastOnce(Flow<KafkaMessage, Done, ?> flow) {
        Promise streamCompleted = Promise$.MODULE$.apply();
        Props consumerProps = KafkaSubscriberActor$.MODULE$.props(this.kafkaConfig(), this.subscribe, flow, this.consumerSettings(), (Promise<Done>)streamCompleted, this.mat, this.dispatcher());
        Props backoffConsumerProps = BackoffSupervisor$.MODULE$.props(Backoff$.MODULE$.onStop(consumerProps, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaConsumerActor", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.consumerId()), this.subscribe.topics().mkString("-")})), this.subscribe.minBackoff(), this.subscribe.maxBackoff(), 0.2).withDefaultStoppingStrategy());
        this.context.actorOf(backoffConsumerProps, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KafkaBackoffConsumer", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.consumerId()), this.subscribe.topics().mkString("-")})));
        return streamCompleted.future();
    }

    public KafkaSubscriber(Subscribe subscribe, ActorSystem system, Materializer mat, ActorRefFactory context) {
        this.subscribe = subscribe;
        this.system = system;
        this.mat = mat;
        this.context = context;
        this.dispatcher = system.dispatchers().lookup("dispatchers.kafka-dispatcher");
        this.kafkaConfig = KafkaConfig$.MODULE$.apply(system.settings().config());
    }
}

