/*
 * Decompiled with CFR 0.152.
 */
package nl.tradecloud.kafka;

import akka.Done;
import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.Props$;
import akka.event.LoggingAdapter;
import akka.kafka.ConsumerSettings;
import akka.remote.WireFormats;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import nl.tradecloud.kafka.KafkaMessage;
import nl.tradecloud.kafka.KafkaMessageSerializer$;
import nl.tradecloud.kafka.KafkaSubscriberActor;
import nl.tradecloud.kafka.command.Subscribe;
import nl.tradecloud.kafka.config.KafkaConfig;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.reflect.ClassTag$;

public final class KafkaSubscriberActor$ {
    public static final KafkaSubscriberActor$ MODULE$;

    static {
        new KafkaSubscriberActor$();
    }

    public Props props(KafkaConfig kafkaConfig, Subscribe subscribe, Flow<KafkaMessage, Done, ?> flow, ConsumerSettings<String, byte[]> consumerSettings, Promise<Done> streamCompleted, Materializer mat, ExecutionContext ec) {
        return Props$.MODULE$.apply((Function0)new Serializable(kafkaConfig, subscribe, flow, consumerSettings, streamCompleted, mat, ec){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$1;
            private final Subscribe subscribe$1;
            private final Flow flow$1;
            private final ConsumerSettings consumerSettings$1;
            private final Promise streamCompleted$1;
            private final Materializer mat$1;
            private final ExecutionContext ec$1;

            public final KafkaSubscriberActor apply() {
                return new KafkaSubscriberActor(this.kafkaConfig$1, this.subscribe$1, this.flow$1, (ConsumerSettings<String, byte[]>)this.consumerSettings$1, (Promise<Done>)this.streamCompleted$1, this.mat$1, this.ec$1);
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
                this.subscribe$1 = subscribe$1;
                this.flow$1 = flow$1;
                this.consumerSettings$1 = consumerSettings$1;
                this.streamCompleted$1 = streamCompleted$1;
                this.mat$1 = mat$1;
                this.ec$1 = ec$1;
            }
        }, ClassTag$.MODULE$.apply(KafkaSubscriberActor.class));
    }

    public Flow<byte[], KafkaMessage, NotUsed> deserializeFlow(ActorSystem system, LoggingAdapter log) {
        return (Flow)Flow$.MODULE$.apply().mapConcat((Function1)new Serializable(system, log){
            public static final long serialVersionUID = 0L;
            private final ActorSystem system$1;
            private final LoggingAdapter log$1;

            public final List<KafkaMessage> apply(byte[] msg) {
                Nil$ nil$;
                try {
                    Object deserializedMsg = KafkaMessageSerializer$.MODULE$.deserialize(this.system$1, WireFormats.SerializedMessage.parseFrom((byte[])msg));
                    nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaMessage[]{new KafkaMessage(deserializedMsg)}));
                }
                catch (Throwable throwable) {
                    this.log$1.error(throwable, "Kafka message not deserializable, resuming...");
                    nil$ = Nil$.MODULE$;
                }
                return nil$;
            }
            {
                this.system$1 = system$1;
                this.log$1 = log$1;
            }
        }).map((Function1)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final LoggingAdapter log$1;

            public final KafkaMessage apply(KafkaMessage wrappedMsg) {
                this.log$1.debug("Received msg, msg={}", wrappedMsg.msg());
                return wrappedMsg;
            }
            {
                this.log$1 = log$1;
            }
        });
    }

    private KafkaSubscriberActor$() {
        MODULE$ = this;
    }
}

