/*
 * Decompiled with CFR 0.152.
 */
package nl.tudelft.simulation.dsol.swing.animation.D2;

import java.rmi.RemoteException;
import nl.tudelft.simulation.dsol.simulators.AnimatorInterface;
import org.djunits.unit.FrequencyUnit;
import org.djunits.value.vdouble.scalar.Frequency;
import org.djutils.event.EventListener;
import org.djutils.event.EventListenerMap;
import org.djutils.event.EventProducer;
import org.djutils.event.LocalEventProducer;

public class AnimationUpdaterThread
extends Thread
implements EventProducer {
    private static final long serialVersionUID = 20230305L;
    private final EventProducer eventProducer;
    private Frequency updateFrequency = new Frequency(30.0, FrequencyUnit.PER_SECOND);
    private boolean running = false;

    public AnimationUpdaterThread() {
        this((EventProducer)new LocalEventProducer());
    }

    public AnimationUpdaterThread(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            try {
                AnimationUpdaterThread.sleep((long)(1000.0 / this.updateFrequency.si));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.eventProducer.fireEvent(AnimatorInterface.UPDATE_ANIMATION_EVENT);
            }
            catch (RemoteException remoteException) {}
        }
    }

    public void pause() {
        this.running = false;
    }

    void addListener(EventListener listener) throws RemoteException {
        this.eventProducer.addListener(listener, AnimatorInterface.UPDATE_ANIMATION_EVENT);
    }

    public Frequency getUpdateFrequency() {
        return this.updateFrequency;
    }

    public void setUpdateFrequency(Frequency updateFrequency) {
        this.updateFrequency = updateFrequency;
    }

    public EventListenerMap getEventListenerMap() throws RemoteException {
        return this.eventProducer.getEventListenerMap();
    }
}

